package zio.aws.rds.model
import zio.aws.rds.model.primitives.BooleanOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StartActivityStreamRequest(
    resourceArn: String,
    mode: zio.aws.rds.model.ActivityStreamMode,
    kmsKeyId: String,
    applyImmediately: scala.Option[BooleanOptional] = None,
    engineNativeAuditFieldsIncluded: scala.Option[BooleanOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.StartActivityStreamRequest = {
    import StartActivityStreamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.StartActivityStreamRequest
      .builder()
      .resourceArn(resourceArn: java.lang.String)
      .mode(mode.unwrap)
      .kmsKeyId(kmsKeyId: java.lang.String)
      .optionallyWith(applyImmediately.map(value => value: java.lang.Boolean))(
        _.applyImmediately
      )
      .optionallyWith(
        engineNativeAuditFieldsIncluded.map(value => value: java.lang.Boolean)
      )(_.engineNativeAuditFieldsIncluded)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.StartActivityStreamRequest.ReadOnly =
    zio.aws.rds.model.StartActivityStreamRequest.wrap(buildAwsValue())
}
object StartActivityStreamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.StartActivityStreamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.StartActivityStreamRequest =
      zio.aws.rds.model.StartActivityStreamRequest(
        resourceArn,
        mode,
        kmsKeyId,
        applyImmediately.map(value => value),
        engineNativeAuditFieldsIncluded.map(value => value)
      )
    def resourceArn: String
    def mode: zio.aws.rds.model.ActivityStreamMode
    def kmsKeyId: String
    def applyImmediately: scala.Option[BooleanOptional]
    def engineNativeAuditFieldsIncluded: scala.Option[BooleanOptional]
    def getResourceArn: ZIO[Any, Nothing, String] = ZIO.succeed(resourceArn)
    def getMode: ZIO[Any, Nothing, zio.aws.rds.model.ActivityStreamMode] =
      ZIO.succeed(mode)
    def getKmsKeyId: ZIO[Any, Nothing, String] = ZIO.succeed(kmsKeyId)
    def getApplyImmediately: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("applyImmediately", applyImmediately)
    def getEngineNativeAuditFieldsIncluded
        : ZIO[Any, AwsError, BooleanOptional] = AwsError.unwrapOptionField(
      "engineNativeAuditFieldsIncluded",
      engineNativeAuditFieldsIncluded
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.StartActivityStreamRequest
  ) extends zio.aws.rds.model.StartActivityStreamRequest.ReadOnly {
    override val resourceArn: String = impl.resourceArn(): String
    override val mode: zio.aws.rds.model.ActivityStreamMode =
      zio.aws.rds.model.ActivityStreamMode.wrap(impl.mode())
    override val kmsKeyId: String = impl.kmsKeyId(): String
    override val applyImmediately: scala.Option[BooleanOptional] =
      scala.Option(impl.applyImmediately()).map(value => value: BooleanOptional)
    override val engineNativeAuditFieldsIncluded
        : scala.Option[BooleanOptional] = scala
      .Option(impl.engineNativeAuditFieldsIncluded())
      .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.StartActivityStreamRequest
  ): zio.aws.rds.model.StartActivityStreamRequest.ReadOnly = new Wrapper(impl)
}
