package zio.aws.rds.model
import java.lang.Integer
import zio.aws.rds.model.primitives.{BooleanOptional, IntegerOptional}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ScalingConfiguration(
    minCapacity: scala.Option[IntegerOptional] = None,
    maxCapacity: scala.Option[IntegerOptional] = None,
    autoPause: scala.Option[BooleanOptional] = None,
    secondsUntilAutoPause: scala.Option[IntegerOptional] = None,
    timeoutAction: scala.Option[String] = None,
    secondsBeforeTimeout: scala.Option[IntegerOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ScalingConfiguration = {
    import ScalingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ScalingConfiguration
      .builder()
      .optionallyWith(minCapacity.map(value => value: Integer))(_.minCapacity)
      .optionallyWith(maxCapacity.map(value => value: Integer))(_.maxCapacity)
      .optionallyWith(autoPause.map(value => value: java.lang.Boolean))(
        _.autoPause
      )
      .optionallyWith(secondsUntilAutoPause.map(value => value: Integer))(
        _.secondsUntilAutoPause
      )
      .optionallyWith(timeoutAction.map(value => value: java.lang.String))(
        _.timeoutAction
      )
      .optionallyWith(secondsBeforeTimeout.map(value => value: Integer))(
        _.secondsBeforeTimeout
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ScalingConfiguration.ReadOnly =
    zio.aws.rds.model.ScalingConfiguration.wrap(buildAwsValue())
}
object ScalingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ScalingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ScalingConfiguration =
      zio.aws.rds.model.ScalingConfiguration(
        minCapacity.map(value => value),
        maxCapacity.map(value => value),
        autoPause.map(value => value),
        secondsUntilAutoPause.map(value => value),
        timeoutAction.map(value => value),
        secondsBeforeTimeout.map(value => value)
      )
    def minCapacity: scala.Option[IntegerOptional]
    def maxCapacity: scala.Option[IntegerOptional]
    def autoPause: scala.Option[BooleanOptional]
    def secondsUntilAutoPause: scala.Option[IntegerOptional]
    def timeoutAction: scala.Option[String]
    def secondsBeforeTimeout: scala.Option[IntegerOptional]
    def getMinCapacity: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("minCapacity", minCapacity)
    def getMaxCapacity: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxCapacity", maxCapacity)
    def getAutoPause: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("autoPause", autoPause)
    def getSecondsUntilAutoPause: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("secondsUntilAutoPause", secondsUntilAutoPause)
    def getTimeoutAction: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("timeoutAction", timeoutAction)
    def getSecondsBeforeTimeout: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("secondsBeforeTimeout", secondsBeforeTimeout)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ScalingConfiguration
  ) extends zio.aws.rds.model.ScalingConfiguration.ReadOnly {
    override val minCapacity: scala.Option[IntegerOptional] =
      scala.Option(impl.minCapacity()).map(value => value: IntegerOptional)
    override val maxCapacity: scala.Option[IntegerOptional] =
      scala.Option(impl.maxCapacity()).map(value => value: IntegerOptional)
    override val autoPause: scala.Option[BooleanOptional] =
      scala.Option(impl.autoPause()).map(value => value: BooleanOptional)
    override val secondsUntilAutoPause: scala.Option[IntegerOptional] = scala
      .Option(impl.secondsUntilAutoPause())
      .map(value => value: IntegerOptional)
    override val timeoutAction: scala.Option[String] =
      scala.Option(impl.timeoutAction()).map(value => value: String)
    override val secondsBeforeTimeout: scala.Option[IntegerOptional] = scala
      .Option(impl.secondsBeforeTimeout())
      .map(value => value: IntegerOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ScalingConfiguration
  ): zio.aws.rds.model.ScalingConfiguration.ReadOnly = new Wrapper(impl)
}
