package zio.aws.rds.model
import java.lang.Integer
import zio.aws.rds.model.primitives.{
  LongOptional,
  BooleanOptional,
  IntegerOptional
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RestoreDbClusterFromSnapshotRequest(
    availabilityZones: scala.Option[Iterable[String]] = None,
    dbClusterIdentifier: String,
    snapshotIdentifier: String,
    engine: String,
    engineVersion: scala.Option[String] = None,
    port: scala.Option[IntegerOptional] = None,
    dbSubnetGroupName: scala.Option[String] = None,
    databaseName: scala.Option[String] = None,
    optionGroupName: scala.Option[String] = None,
    vpcSecurityGroupIds: scala.Option[Iterable[String]] = None,
    tags: scala.Option[Iterable[zio.aws.rds.model.Tag]] = None,
    kmsKeyId: scala.Option[String] = None,
    enableIAMDatabaseAuthentication: scala.Option[BooleanOptional] = None,
    backtrackWindow: scala.Option[LongOptional] = None,
    enableCloudwatchLogsExports: scala.Option[Iterable[String]] = None,
    engineMode: scala.Option[String] = None,
    scalingConfiguration: scala.Option[zio.aws.rds.model.ScalingConfiguration] =
      None,
    dbClusterParameterGroupName: scala.Option[String] = None,
    deletionProtection: scala.Option[BooleanOptional] = None,
    copyTagsToSnapshot: scala.Option[BooleanOptional] = None,
    domain: scala.Option[String] = None,
    domainIAMRoleName: scala.Option[String] = None,
    dbClusterInstanceClass: scala.Option[String] = None,
    storageType: scala.Option[String] = None,
    iops: scala.Option[IntegerOptional] = None,
    publiclyAccessible: scala.Option[BooleanOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.RestoreDbClusterFromSnapshotRequest = {
    import RestoreDbClusterFromSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.RestoreDbClusterFromSnapshotRequest
      .builder()
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .dbClusterIdentifier(dbClusterIdentifier: java.lang.String)
      .snapshotIdentifier(snapshotIdentifier: java.lang.String)
      .engine(engine: java.lang.String)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(dbSubnetGroupName.map(value => value: java.lang.String))(
        _.dbSubnetGroupName
      )
      .optionallyWith(databaseName.map(value => value: java.lang.String))(
        _.databaseName
      )
      .optionallyWith(optionGroupName.map(value => value: java.lang.String))(
        _.optionGroupName
      )
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        enableIAMDatabaseAuthentication.map(value => value: java.lang.Boolean)
      )(_.enableIAMDatabaseAuthentication)
      .optionallyWith(backtrackWindow.map(value => value: java.lang.Long))(
        _.backtrackWindow
      )
      .optionallyWith(
        enableCloudwatchLogsExports.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.enableCloudwatchLogsExports)
      .optionallyWith(engineMode.map(value => value: java.lang.String))(
        _.engineMode
      )
      .optionallyWith(scalingConfiguration.map(value => value.buildAwsValue()))(
        _.scalingConfiguration
      )
      .optionallyWith(
        dbClusterParameterGroupName.map(value => value: java.lang.String)
      )(_.dbClusterParameterGroupName)
      .optionallyWith(
        deletionProtection.map(value => value: java.lang.Boolean)
      )(_.deletionProtection)
      .optionallyWith(
        copyTagsToSnapshot.map(value => value: java.lang.Boolean)
      )(_.copyTagsToSnapshot)
      .optionallyWith(domain.map(value => value: java.lang.String))(_.domain)
      .optionallyWith(domainIAMRoleName.map(value => value: java.lang.String))(
        _.domainIAMRoleName
      )
      .optionallyWith(
        dbClusterInstanceClass.map(value => value: java.lang.String)
      )(_.dbClusterInstanceClass)
      .optionallyWith(storageType.map(value => value: java.lang.String))(
        _.storageType
      )
      .optionallyWith(iops.map(value => value: Integer))(_.iops)
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.RestoreDbClusterFromSnapshotRequest.ReadOnly =
    zio.aws.rds.model.RestoreDbClusterFromSnapshotRequest.wrap(buildAwsValue())
}
object RestoreDbClusterFromSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.RestoreDbClusterFromSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.RestoreDbClusterFromSnapshotRequest =
      zio.aws.rds.model.RestoreDbClusterFromSnapshotRequest(
        availabilityZones.map(value => value),
        dbClusterIdentifier,
        snapshotIdentifier,
        engine,
        engineVersion.map(value => value),
        port.map(value => value),
        dbSubnetGroupName.map(value => value),
        databaseName.map(value => value),
        optionGroupName.map(value => value),
        vpcSecurityGroupIds.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        kmsKeyId.map(value => value),
        enableIAMDatabaseAuthentication.map(value => value),
        backtrackWindow.map(value => value),
        enableCloudwatchLogsExports.map(value => value),
        engineMode.map(value => value),
        scalingConfiguration.map(value => value.asEditable),
        dbClusterParameterGroupName.map(value => value),
        deletionProtection.map(value => value),
        copyTagsToSnapshot.map(value => value),
        domain.map(value => value),
        domainIAMRoleName.map(value => value),
        dbClusterInstanceClass.map(value => value),
        storageType.map(value => value),
        iops.map(value => value),
        publiclyAccessible.map(value => value)
      )
    def availabilityZones: scala.Option[List[String]]
    def dbClusterIdentifier: String
    def snapshotIdentifier: String
    def engine: String
    def engineVersion: scala.Option[String]
    def port: scala.Option[IntegerOptional]
    def dbSubnetGroupName: scala.Option[String]
    def databaseName: scala.Option[String]
    def optionGroupName: scala.Option[String]
    def vpcSecurityGroupIds: scala.Option[List[String]]
    def tags: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]]
    def kmsKeyId: scala.Option[String]
    def enableIAMDatabaseAuthentication: scala.Option[BooleanOptional]
    def backtrackWindow: scala.Option[LongOptional]
    def enableCloudwatchLogsExports: scala.Option[List[String]]
    def engineMode: scala.Option[String]
    def scalingConfiguration
        : scala.Option[zio.aws.rds.model.ScalingConfiguration.ReadOnly]
    def dbClusterParameterGroupName: scala.Option[String]
    def deletionProtection: scala.Option[BooleanOptional]
    def copyTagsToSnapshot: scala.Option[BooleanOptional]
    def domain: scala.Option[String]
    def domainIAMRoleName: scala.Option[String]
    def dbClusterInstanceClass: scala.Option[String]
    def storageType: scala.Option[String]
    def iops: scala.Option[IntegerOptional]
    def publiclyAccessible: scala.Option[BooleanOptional]
    def getAvailabilityZones: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getDbClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterIdentifier)
    def getSnapshotIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(snapshotIdentifier)
    def getEngine: ZIO[Any, Nothing, String] = ZIO.succeed(engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getDbSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSubnetGroupName", dbSubnetGroupName)
    def getDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getOptionGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optionGroupName", optionGroupName)
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
    def getTags: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getEnableIAMDatabaseAuthentication
        : ZIO[Any, AwsError, BooleanOptional] = AwsError.unwrapOptionField(
      "enableIAMDatabaseAuthentication",
      enableIAMDatabaseAuthentication
    )
    def getBacktrackWindow: ZIO[Any, AwsError, LongOptional] =
      AwsError.unwrapOptionField("backtrackWindow", backtrackWindow)
    def getEnableCloudwatchLogsExports: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "enableCloudwatchLogsExports",
        enableCloudwatchLogsExports
      )
    def getEngineMode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineMode", engineMode)
    def getScalingConfiguration
        : ZIO[Any, AwsError, zio.aws.rds.model.ScalingConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("scalingConfiguration", scalingConfiguration)
    def getDbClusterParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbClusterParameterGroupName",
        dbClusterParameterGroupName
      )
    def getDeletionProtection: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
    def getCopyTagsToSnapshot: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("copyTagsToSnapshot", copyTagsToSnapshot)
    def getDomain: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domain", domain)
    def getDomainIAMRoleName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domainIAMRoleName", domainIAMRoleName)
    def getDbClusterInstanceClass: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("dbClusterInstanceClass", dbClusterInstanceClass)
    def getStorageType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getIops: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("iops", iops)
    def getPubliclyAccessible: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.RestoreDbClusterFromSnapshotRequest
  ) extends zio.aws.rds.model.RestoreDbClusterFromSnapshotRequest.ReadOnly {
    override val availabilityZones: scala.Option[List[String]] = scala
      .Option(impl.availabilityZones())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val dbClusterIdentifier: String =
      impl.dbClusterIdentifier(): String
    override val snapshotIdentifier: String = impl.snapshotIdentifier(): String
    override val engine: String = impl.engine(): String
    override val engineVersion: scala.Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val port: scala.Option[IntegerOptional] =
      scala.Option(impl.port()).map(value => value: IntegerOptional)
    override val dbSubnetGroupName: scala.Option[String] =
      scala.Option(impl.dbSubnetGroupName()).map(value => value: String)
    override val databaseName: scala.Option[String] =
      scala.Option(impl.databaseName()).map(value => value: String)
    override val optionGroupName: scala.Option[String] =
      scala.Option(impl.optionGroupName()).map(value => value: String)
    override val vpcSecurityGroupIds: scala.Option[List[String]] = scala
      .Option(impl.vpcSecurityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val tags: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
    override val kmsKeyId: scala.Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val enableIAMDatabaseAuthentication
        : scala.Option[BooleanOptional] = scala
      .Option(impl.enableIAMDatabaseAuthentication())
      .map(value => value: BooleanOptional)
    override val backtrackWindow: scala.Option[LongOptional] =
      scala.Option(impl.backtrackWindow()).map(value => value: LongOptional)
    override val enableCloudwatchLogsExports: scala.Option[List[String]] = scala
      .Option(impl.enableCloudwatchLogsExports())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val engineMode: scala.Option[String] =
      scala.Option(impl.engineMode()).map(value => value: String)
    override val scalingConfiguration
        : scala.Option[zio.aws.rds.model.ScalingConfiguration.ReadOnly] = scala
      .Option(impl.scalingConfiguration())
      .map(value => zio.aws.rds.model.ScalingConfiguration.wrap(value))
    override val dbClusterParameterGroupName: scala.Option[String] = scala
      .Option(impl.dbClusterParameterGroupName())
      .map(value => value: String)
    override val deletionProtection: scala.Option[BooleanOptional] = scala
      .Option(impl.deletionProtection())
      .map(value => value: BooleanOptional)
    override val copyTagsToSnapshot: scala.Option[BooleanOptional] = scala
      .Option(impl.copyTagsToSnapshot())
      .map(value => value: BooleanOptional)
    override val domain: scala.Option[String] =
      scala.Option(impl.domain()).map(value => value: String)
    override val domainIAMRoleName: scala.Option[String] =
      scala.Option(impl.domainIAMRoleName()).map(value => value: String)
    override val dbClusterInstanceClass: scala.Option[String] =
      scala.Option(impl.dbClusterInstanceClass()).map(value => value: String)
    override val storageType: scala.Option[String] =
      scala.Option(impl.storageType()).map(value => value: String)
    override val iops: scala.Option[IntegerOptional] =
      scala.Option(impl.iops()).map(value => value: IntegerOptional)
    override val publiclyAccessible: scala.Option[BooleanOptional] = scala
      .Option(impl.publiclyAccessible())
      .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.RestoreDbClusterFromSnapshotRequest
  ): zio.aws.rds.model.RestoreDbClusterFromSnapshotRequest.ReadOnly =
    new Wrapper(impl)
}
