package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RemoveSourceIdentifierFromSubscriptionResponse(
    eventSubscription: scala.Option[zio.aws.rds.model.EventSubscription] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.RemoveSourceIdentifierFromSubscriptionResponse = {
    import RemoveSourceIdentifierFromSubscriptionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.RemoveSourceIdentifierFromSubscriptionResponse
      .builder()
      .optionallyWith(eventSubscription.map(value => value.buildAwsValue()))(
        _.eventSubscription
      )
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.RemoveSourceIdentifierFromSubscriptionResponse.ReadOnly =
    zio.aws.rds.model.RemoveSourceIdentifierFromSubscriptionResponse
      .wrap(buildAwsValue())
}
object RemoveSourceIdentifierFromSubscriptionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.RemoveSourceIdentifierFromSubscriptionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.rds.model.RemoveSourceIdentifierFromSubscriptionResponse =
      zio.aws.rds.model.RemoveSourceIdentifierFromSubscriptionResponse(
        eventSubscription.map(value => value.asEditable)
      )
    def eventSubscription
        : scala.Option[zio.aws.rds.model.EventSubscription.ReadOnly]
    def getEventSubscription
        : ZIO[Any, AwsError, zio.aws.rds.model.EventSubscription.ReadOnly] =
      AwsError.unwrapOptionField("eventSubscription", eventSubscription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.RemoveSourceIdentifierFromSubscriptionResponse
  ) extends zio.aws.rds.model.RemoveSourceIdentifierFromSubscriptionResponse.ReadOnly {
    override val eventSubscription
        : scala.Option[zio.aws.rds.model.EventSubscription.ReadOnly] = scala
      .Option(impl.eventSubscription())
      .map(value => zio.aws.rds.model.EventSubscription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.RemoveSourceIdentifierFromSubscriptionResponse
  ): zio.aws.rds.model.RemoveSourceIdentifierFromSubscriptionResponse.ReadOnly =
    new Wrapper(impl)
}
