package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RecurringCharge(
    recurringChargeAmount: scala.Option[Double] = None,
    recurringChargeFrequency: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.RecurringCharge = {
    import RecurringCharge.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.RecurringCharge
      .builder()
      .optionallyWith(
        recurringChargeAmount.map(value => value: java.lang.Double)
      )(_.recurringChargeAmount)
      .optionallyWith(
        recurringChargeFrequency.map(value => value: java.lang.String)
      )(_.recurringChargeFrequency)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.RecurringCharge.ReadOnly =
    zio.aws.rds.model.RecurringCharge.wrap(buildAwsValue())
}
object RecurringCharge {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.RecurringCharge
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.RecurringCharge =
      zio.aws.rds.model.RecurringCharge(
        recurringChargeAmount.map(value => value),
        recurringChargeFrequency.map(value => value)
      )
    def recurringChargeAmount: scala.Option[Double]
    def recurringChargeFrequency: scala.Option[String]
    def getRecurringChargeAmount: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("recurringChargeAmount", recurringChargeAmount)
    def getRecurringChargeFrequency: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("recurringChargeFrequency", recurringChargeFrequency)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.RecurringCharge
  ) extends zio.aws.rds.model.RecurringCharge.ReadOnly {
    override val recurringChargeAmount: scala.Option[Double] =
      scala.Option(impl.recurringChargeAmount()).map(value => value: Double)
    override val recurringChargeFrequency: scala.Option[String] =
      scala.Option(impl.recurringChargeFrequency()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.RecurringCharge
  ): zio.aws.rds.model.RecurringCharge.ReadOnly = new Wrapper(impl)
}
