package zio.aws.rds.model
import java.lang.Integer
import zio.aws.rds.model.primitives.{
  BooleanOptional,
  DoubleOptional,
  IntegerOptional
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class OrderableDBInstanceOption(
    engine: scala.Option[String] = None,
    engineVersion: scala.Option[String] = None,
    dbInstanceClass: scala.Option[String] = None,
    licenseModel: scala.Option[String] = None,
    availabilityZoneGroup: scala.Option[String] = None,
    availabilityZones: scala.Option[Iterable[
      zio.aws.rds.model.AvailabilityZone
    ]] = None,
    multiAZCapable: scala.Option[Boolean] = None,
    readReplicaCapable: scala.Option[Boolean] = None,
    vpc: scala.Option[Boolean] = None,
    supportsStorageEncryption: scala.Option[Boolean] = None,
    storageType: scala.Option[String] = None,
    supportsIops: scala.Option[Boolean] = None,
    supportsEnhancedMonitoring: scala.Option[Boolean] = None,
    supportsIAMDatabaseAuthentication: scala.Option[Boolean] = None,
    supportsPerformanceInsights: scala.Option[Boolean] = None,
    minStorageSize: scala.Option[IntegerOptional] = None,
    maxStorageSize: scala.Option[IntegerOptional] = None,
    minIopsPerDbInstance: scala.Option[IntegerOptional] = None,
    maxIopsPerDbInstance: scala.Option[IntegerOptional] = None,
    minIopsPerGib: scala.Option[DoubleOptional] = None,
    maxIopsPerGib: scala.Option[DoubleOptional] = None,
    availableProcessorFeatures: scala.Option[Iterable[
      zio.aws.rds.model.AvailableProcessorFeature
    ]] = None,
    supportedEngineModes: scala.Option[Iterable[String]] = None,
    supportsStorageAutoscaling: scala.Option[BooleanOptional] = None,
    supportsKerberosAuthentication: scala.Option[BooleanOptional] = None,
    outpostCapable: scala.Option[Boolean] = None,
    supportedActivityStreamModes: scala.Option[Iterable[String]] = None,
    supportsGlobalDatabases: scala.Option[Boolean] = None,
    supportsClusters: scala.Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.OrderableDBInstanceOption = {
    import OrderableDBInstanceOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.OrderableDBInstanceOption
      .builder()
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(dbInstanceClass.map(value => value: java.lang.String))(
        _.dbInstanceClass
      )
      .optionallyWith(licenseModel.map(value => value: java.lang.String))(
        _.licenseModel
      )
      .optionallyWith(
        availabilityZoneGroup.map(value => value: java.lang.String)
      )(_.availabilityZoneGroup)
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(multiAZCapable.map(value => value: java.lang.Boolean))(
        _.multiAZCapable
      )
      .optionallyWith(
        readReplicaCapable.map(value => value: java.lang.Boolean)
      )(_.readReplicaCapable)
      .optionallyWith(vpc.map(value => value: java.lang.Boolean))(_.vpc)
      .optionallyWith(
        supportsStorageEncryption.map(value => value: java.lang.Boolean)
      )(_.supportsStorageEncryption)
      .optionallyWith(storageType.map(value => value: java.lang.String))(
        _.storageType
      )
      .optionallyWith(supportsIops.map(value => value: java.lang.Boolean))(
        _.supportsIops
      )
      .optionallyWith(
        supportsEnhancedMonitoring.map(value => value: java.lang.Boolean)
      )(_.supportsEnhancedMonitoring)
      .optionallyWith(
        supportsIAMDatabaseAuthentication.map(value => value: java.lang.Boolean)
      )(_.supportsIAMDatabaseAuthentication)
      .optionallyWith(
        supportsPerformanceInsights.map(value => value: java.lang.Boolean)
      )(_.supportsPerformanceInsights)
      .optionallyWith(minStorageSize.map(value => value: Integer))(
        _.minStorageSize
      )
      .optionallyWith(maxStorageSize.map(value => value: Integer))(
        _.maxStorageSize
      )
      .optionallyWith(minIopsPerDbInstance.map(value => value: Integer))(
        _.minIopsPerDbInstance
      )
      .optionallyWith(maxIopsPerDbInstance.map(value => value: Integer))(
        _.maxIopsPerDbInstance
      )
      .optionallyWith(minIopsPerGib.map(value => value: java.lang.Double))(
        _.minIopsPerGib
      )
      .optionallyWith(maxIopsPerGib.map(value => value: java.lang.Double))(
        _.maxIopsPerGib
      )
      .optionallyWith(
        availableProcessorFeatures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.availableProcessorFeatures)
      .optionallyWith(
        supportedEngineModes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.supportedEngineModes)
      .optionallyWith(
        supportsStorageAutoscaling.map(value => value: java.lang.Boolean)
      )(_.supportsStorageAutoscaling)
      .optionallyWith(
        supportsKerberosAuthentication.map(value => value: java.lang.Boolean)
      )(_.supportsKerberosAuthentication)
      .optionallyWith(outpostCapable.map(value => value: java.lang.Boolean))(
        _.outpostCapable
      )
      .optionallyWith(
        supportedActivityStreamModes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.supportedActivityStreamModes)
      .optionallyWith(
        supportsGlobalDatabases.map(value => value: java.lang.Boolean)
      )(_.supportsGlobalDatabases)
      .optionallyWith(supportsClusters.map(value => value: java.lang.Boolean))(
        _.supportsClusters
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.OrderableDBInstanceOption.ReadOnly =
    zio.aws.rds.model.OrderableDBInstanceOption.wrap(buildAwsValue())
}
object OrderableDBInstanceOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.OrderableDBInstanceOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.OrderableDBInstanceOption =
      zio.aws.rds.model.OrderableDBInstanceOption(
        engine.map(value => value),
        engineVersion.map(value => value),
        dbInstanceClass.map(value => value),
        licenseModel.map(value => value),
        availabilityZoneGroup.map(value => value),
        availabilityZones.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        multiAZCapable.map(value => value),
        readReplicaCapable.map(value => value),
        vpc.map(value => value),
        supportsStorageEncryption.map(value => value),
        storageType.map(value => value),
        supportsIops.map(value => value),
        supportsEnhancedMonitoring.map(value => value),
        supportsIAMDatabaseAuthentication.map(value => value),
        supportsPerformanceInsights.map(value => value),
        minStorageSize.map(value => value),
        maxStorageSize.map(value => value),
        minIopsPerDbInstance.map(value => value),
        maxIopsPerDbInstance.map(value => value),
        minIopsPerGib.map(value => value),
        maxIopsPerGib.map(value => value),
        availableProcessorFeatures.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        supportedEngineModes.map(value => value),
        supportsStorageAutoscaling.map(value => value),
        supportsKerberosAuthentication.map(value => value),
        outpostCapable.map(value => value),
        supportedActivityStreamModes.map(value => value),
        supportsGlobalDatabases.map(value => value),
        supportsClusters.map(value => value)
      )
    def engine: scala.Option[String]
    def engineVersion: scala.Option[String]
    def dbInstanceClass: scala.Option[String]
    def licenseModel: scala.Option[String]
    def availabilityZoneGroup: scala.Option[String]
    def availabilityZones
        : scala.Option[List[zio.aws.rds.model.AvailabilityZone.ReadOnly]]
    def multiAZCapable: scala.Option[Boolean]
    def readReplicaCapable: scala.Option[Boolean]
    def vpc: scala.Option[Boolean]
    def supportsStorageEncryption: scala.Option[Boolean]
    def storageType: scala.Option[String]
    def supportsIops: scala.Option[Boolean]
    def supportsEnhancedMonitoring: scala.Option[Boolean]
    def supportsIAMDatabaseAuthentication: scala.Option[Boolean]
    def supportsPerformanceInsights: scala.Option[Boolean]
    def minStorageSize: scala.Option[IntegerOptional]
    def maxStorageSize: scala.Option[IntegerOptional]
    def minIopsPerDbInstance: scala.Option[IntegerOptional]
    def maxIopsPerDbInstance: scala.Option[IntegerOptional]
    def minIopsPerGib: scala.Option[DoubleOptional]
    def maxIopsPerGib: scala.Option[DoubleOptional]
    def availableProcessorFeatures: scala.Option[List[
      zio.aws.rds.model.AvailableProcessorFeature.ReadOnly
    ]]
    def supportedEngineModes: scala.Option[List[String]]
    def supportsStorageAutoscaling: scala.Option[BooleanOptional]
    def supportsKerberosAuthentication: scala.Option[BooleanOptional]
    def outpostCapable: scala.Option[Boolean]
    def supportedActivityStreamModes: scala.Option[List[String]]
    def supportsGlobalDatabases: scala.Option[Boolean]
    def supportsClusters: scala.Option[Boolean]
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getDbInstanceClass: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceClass", dbInstanceClass)
    def getLicenseModel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("licenseModel", licenseModel)
    def getAvailabilityZoneGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZoneGroup", availabilityZoneGroup)
    def getAvailabilityZones: ZIO[Any, AwsError, List[
      zio.aws.rds.model.AvailabilityZone.ReadOnly
    ]] = AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getMultiAZCapable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("multiAZCapable", multiAZCapable)
    def getReadReplicaCapable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("readReplicaCapable", readReplicaCapable)
    def getVpc: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("vpc", vpc)
    def getSupportsStorageEncryption: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("supportsStorageEncryption", supportsStorageEncryption)
    def getStorageType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getSupportsIops: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("supportsIops", supportsIops)
    def getSupportsEnhancedMonitoring: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "supportsEnhancedMonitoring",
        supportsEnhancedMonitoring
      )
    def getSupportsIAMDatabaseAuthentication: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "supportsIAMDatabaseAuthentication",
        supportsIAMDatabaseAuthentication
      )
    def getSupportsPerformanceInsights: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "supportsPerformanceInsights",
        supportsPerformanceInsights
      )
    def getMinStorageSize: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("minStorageSize", minStorageSize)
    def getMaxStorageSize: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxStorageSize", maxStorageSize)
    def getMinIopsPerDbInstance: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("minIopsPerDbInstance", minIopsPerDbInstance)
    def getMaxIopsPerDbInstance: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxIopsPerDbInstance", maxIopsPerDbInstance)
    def getMinIopsPerGib: ZIO[Any, AwsError, DoubleOptional] =
      AwsError.unwrapOptionField("minIopsPerGib", minIopsPerGib)
    def getMaxIopsPerGib: ZIO[Any, AwsError, DoubleOptional] =
      AwsError.unwrapOptionField("maxIopsPerGib", maxIopsPerGib)
    def getAvailableProcessorFeatures: ZIO[Any, AwsError, List[
      zio.aws.rds.model.AvailableProcessorFeature.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "availableProcessorFeatures",
      availableProcessorFeatures
    )
    def getSupportedEngineModes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("supportedEngineModes", supportedEngineModes)
    def getSupportsStorageAutoscaling: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "supportsStorageAutoscaling",
        supportsStorageAutoscaling
      )
    def getSupportsKerberosAuthentication: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "supportsKerberosAuthentication",
        supportsKerberosAuthentication
      )
    def getOutpostCapable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("outpostCapable", outpostCapable)
    def getSupportedActivityStreamModes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "supportedActivityStreamModes",
        supportedActivityStreamModes
      )
    def getSupportsGlobalDatabases: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("supportsGlobalDatabases", supportsGlobalDatabases)
    def getSupportsClusters: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("supportsClusters", supportsClusters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.OrderableDBInstanceOption
  ) extends zio.aws.rds.model.OrderableDBInstanceOption.ReadOnly {
    override val engine: scala.Option[String] =
      scala.Option(impl.engine()).map(value => value: String)
    override val engineVersion: scala.Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val dbInstanceClass: scala.Option[String] =
      scala.Option(impl.dbInstanceClass()).map(value => value: String)
    override val licenseModel: scala.Option[String] =
      scala.Option(impl.licenseModel()).map(value => value: String)
    override val availabilityZoneGroup: scala.Option[String] =
      scala.Option(impl.availabilityZoneGroup()).map(value => value: String)
    override val availabilityZones
        : scala.Option[List[zio.aws.rds.model.AvailabilityZone.ReadOnly]] =
      scala
        .Option(impl.availabilityZones())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.AvailabilityZone.wrap(item)
          }.toList
        )
    override val multiAZCapable: scala.Option[Boolean] =
      scala.Option(impl.multiAZCapable()).map(value => value: Boolean)
    override val readReplicaCapable: scala.Option[Boolean] =
      scala.Option(impl.readReplicaCapable()).map(value => value: Boolean)
    override val vpc: scala.Option[Boolean] =
      scala.Option(impl.vpc()).map(value => value: Boolean)
    override val supportsStorageEncryption: scala.Option[Boolean] = scala
      .Option(impl.supportsStorageEncryption())
      .map(value => value: Boolean)
    override val storageType: scala.Option[String] =
      scala.Option(impl.storageType()).map(value => value: String)
    override val supportsIops: scala.Option[Boolean] =
      scala.Option(impl.supportsIops()).map(value => value: Boolean)
    override val supportsEnhancedMonitoring: scala.Option[Boolean] = scala
      .Option(impl.supportsEnhancedMonitoring())
      .map(value => value: Boolean)
    override val supportsIAMDatabaseAuthentication: scala.Option[Boolean] =
      scala
        .Option(impl.supportsIAMDatabaseAuthentication())
        .map(value => value: Boolean)
    override val supportsPerformanceInsights: scala.Option[Boolean] = scala
      .Option(impl.supportsPerformanceInsights())
      .map(value => value: Boolean)
    override val minStorageSize: scala.Option[IntegerOptional] =
      scala.Option(impl.minStorageSize()).map(value => value: IntegerOptional)
    override val maxStorageSize: scala.Option[IntegerOptional] =
      scala.Option(impl.maxStorageSize()).map(value => value: IntegerOptional)
    override val minIopsPerDbInstance: scala.Option[IntegerOptional] = scala
      .Option(impl.minIopsPerDbInstance())
      .map(value => value: IntegerOptional)
    override val maxIopsPerDbInstance: scala.Option[IntegerOptional] = scala
      .Option(impl.maxIopsPerDbInstance())
      .map(value => value: IntegerOptional)
    override val minIopsPerGib: scala.Option[DoubleOptional] =
      scala.Option(impl.minIopsPerGib()).map(value => value: DoubleOptional)
    override val maxIopsPerGib: scala.Option[DoubleOptional] =
      scala.Option(impl.maxIopsPerGib()).map(value => value: DoubleOptional)
    override val availableProcessorFeatures: scala.Option[List[
      zio.aws.rds.model.AvailableProcessorFeature.ReadOnly
    ]] = scala
      .Option(impl.availableProcessorFeatures())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.AvailableProcessorFeature.wrap(item)
        }.toList
      )
    override val supportedEngineModes: scala.Option[List[String]] = scala
      .Option(impl.supportedEngineModes())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val supportsStorageAutoscaling: scala.Option[BooleanOptional] =
      scala
        .Option(impl.supportsStorageAutoscaling())
        .map(value => value: BooleanOptional)
    override val supportsKerberosAuthentication: scala.Option[BooleanOptional] =
      scala
        .Option(impl.supportsKerberosAuthentication())
        .map(value => value: BooleanOptional)
    override val outpostCapable: scala.Option[Boolean] =
      scala.Option(impl.outpostCapable()).map(value => value: Boolean)
    override val supportedActivityStreamModes: scala.Option[List[String]] =
      scala
        .Option(impl.supportedActivityStreamModes())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val supportsGlobalDatabases: scala.Option[Boolean] =
      scala.Option(impl.supportsGlobalDatabases()).map(value => value: Boolean)
    override val supportsClusters: scala.Option[Boolean] =
      scala.Option(impl.supportsClusters()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.OrderableDBInstanceOption
  ): zio.aws.rds.model.OrderableDBInstanceOption.ReadOnly = new Wrapper(impl)
}
