package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class OptionSetting(
    name: scala.Option[String] = None,
    value: scala.Option[String] = None,
    defaultValue: scala.Option[String] = None,
    description: scala.Option[String] = None,
    applyType: scala.Option[String] = None,
    dataType: scala.Option[String] = None,
    allowedValues: scala.Option[String] = None,
    isModifiable: scala.Option[Boolean] = None,
    isCollection: scala.Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.OptionSetting = {
    import OptionSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.OptionSetting
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .optionallyWith(defaultValue.map(value => value: java.lang.String))(
        _.defaultValue
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(applyType.map(value => value: java.lang.String))(
        _.applyType
      )
      .optionallyWith(dataType.map(value => value: java.lang.String))(
        _.dataType
      )
      .optionallyWith(allowedValues.map(value => value: java.lang.String))(
        _.allowedValues
      )
      .optionallyWith(isModifiable.map(value => value: java.lang.Boolean))(
        _.isModifiable
      )
      .optionallyWith(isCollection.map(value => value: java.lang.Boolean))(
        _.isCollection
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.OptionSetting.ReadOnly =
    zio.aws.rds.model.OptionSetting.wrap(buildAwsValue())
}
object OptionSetting {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.OptionSetting] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.OptionSetting =
      zio.aws.rds.model.OptionSetting(
        name.map(value => value),
        value.map(value => value),
        defaultValue.map(value => value),
        description.map(value => value),
        applyType.map(value => value),
        dataType.map(value => value),
        allowedValues.map(value => value),
        isModifiable.map(value => value),
        isCollection.map(value => value)
      )
    def name: scala.Option[String]
    def value: scala.Option[String]
    def defaultValue: scala.Option[String]
    def description: scala.Option[String]
    def applyType: scala.Option[String]
    def dataType: scala.Option[String]
    def allowedValues: scala.Option[String]
    def isModifiable: scala.Option[Boolean]
    def isCollection: scala.Option[Boolean]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
    def getDefaultValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("defaultValue", defaultValue)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getApplyType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("applyType", applyType)
    def getDataType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dataType", dataType)
    def getAllowedValues: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("allowedValues", allowedValues)
    def getIsModifiable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isModifiable", isModifiable)
    def getIsCollection: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isCollection", isCollection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.OptionSetting
  ) extends zio.aws.rds.model.OptionSetting.ReadOnly {
    override val name: scala.Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val value: scala.Option[String] =
      scala.Option(impl.value()).map(value => value: String)
    override val defaultValue: scala.Option[String] =
      scala.Option(impl.defaultValue()).map(value => value: String)
    override val description: scala.Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val applyType: scala.Option[String] =
      scala.Option(impl.applyType()).map(value => value: String)
    override val dataType: scala.Option[String] =
      scala.Option(impl.dataType()).map(value => value: String)
    override val allowedValues: scala.Option[String] =
      scala.Option(impl.allowedValues()).map(value => value: String)
    override val isModifiable: scala.Option[Boolean] =
      scala.Option(impl.isModifiable()).map(value => value: Boolean)
    override val isCollection: scala.Option[Boolean] =
      scala.Option(impl.isCollection()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.OptionSetting
  ): zio.aws.rds.model.OptionSetting.ReadOnly = new Wrapper(impl)
}
