package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class OptionGroup(
    optionGroupName: scala.Option[String] = None,
    optionGroupDescription: scala.Option[String] = None,
    engineName: scala.Option[String] = None,
    majorEngineVersion: scala.Option[String] = None,
    options: scala.Option[Iterable[zio.aws.rds.model.Option]] = None,
    allowsVpcAndNonVpcInstanceMemberships: scala.Option[Boolean] = None,
    vpcId: scala.Option[String] = None,
    optionGroupArn: scala.Option[String] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.rds.model.OptionGroup = {
    import OptionGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.OptionGroup
      .builder()
      .optionallyWith(optionGroupName.map(value => value: java.lang.String))(
        _.optionGroupName
      )
      .optionallyWith(
        optionGroupDescription.map(value => value: java.lang.String)
      )(_.optionGroupDescription)
      .optionallyWith(engineName.map(value => value: java.lang.String))(
        _.engineName
      )
      .optionallyWith(majorEngineVersion.map(value => value: java.lang.String))(
        _.majorEngineVersion
      )
      .optionallyWith(
        options.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.options)
      .optionallyWith(
        allowsVpcAndNonVpcInstanceMemberships.map(value =>
          value: java.lang.Boolean
        )
      )(_.allowsVpcAndNonVpcInstanceMemberships)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(optionGroupArn.map(value => value: java.lang.String))(
        _.optionGroupArn
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.OptionGroup.ReadOnly =
    zio.aws.rds.model.OptionGroup.wrap(buildAwsValue())
}
object OptionGroup {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.OptionGroup] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.OptionGroup =
      zio.aws.rds.model.OptionGroup(
        optionGroupName.map(value => value),
        optionGroupDescription.map(value => value),
        engineName.map(value => value),
        majorEngineVersion.map(value => value),
        options.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        allowsVpcAndNonVpcInstanceMemberships.map(value => value),
        vpcId.map(value => value),
        optionGroupArn.map(value => value)
      )
    def optionGroupName: scala.Option[String]
    def optionGroupDescription: scala.Option[String]
    def engineName: scala.Option[String]
    def majorEngineVersion: scala.Option[String]
    def options: scala.Option[List[zio.aws.rds.model.Option.ReadOnly]]
    def allowsVpcAndNonVpcInstanceMemberships: scala.Option[Boolean]
    def vpcId: scala.Option[String]
    def optionGroupArn: scala.Option[String]
    def getOptionGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optionGroupName", optionGroupName)
    def getOptionGroupDescription: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("optionGroupDescription", optionGroupDescription)
    def getEngineName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineName", engineName)
    def getMajorEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("majorEngineVersion", majorEngineVersion)
    def getOptions
        : ZIO[Any, AwsError, List[zio.aws.rds.model.Option.ReadOnly]] =
      AwsError.unwrapOptionField("options", options)
    def getAllowsVpcAndNonVpcInstanceMemberships: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "allowsVpcAndNonVpcInstanceMemberships",
        allowsVpcAndNonVpcInstanceMemberships
      )
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getOptionGroupArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optionGroupArn", optionGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.OptionGroup
  ) extends zio.aws.rds.model.OptionGroup.ReadOnly {
    override val optionGroupName: scala.Option[String] =
      scala.Option(impl.optionGroupName()).map(value => value: String)
    override val optionGroupDescription: scala.Option[String] =
      scala.Option(impl.optionGroupDescription()).map(value => value: String)
    override val engineName: scala.Option[String] =
      scala.Option(impl.engineName()).map(value => value: String)
    override val majorEngineVersion: scala.Option[String] =
      scala.Option(impl.majorEngineVersion()).map(value => value: String)
    override val options
        : scala.Option[List[zio.aws.rds.model.Option.ReadOnly]] = scala
      .Option(impl.options())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.Option.wrap(item)
        }.toList
      )
    override val allowsVpcAndNonVpcInstanceMemberships: scala.Option[Boolean] =
      scala
        .Option(impl.allowsVpcAndNonVpcInstanceMemberships())
        .map(value => value: Boolean)
    override val vpcId: scala.Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
    override val optionGroupArn: scala.Option[String] =
      scala.Option(impl.optionGroupArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.OptionGroup
  ): zio.aws.rds.model.OptionGroup.ReadOnly = new Wrapper(impl)
}
