package zio.aws.rds.model
import java.lang.Integer
import zio.aws.rds.model.primitives.{
  AwsBackupRecoveryPointArn,
  BooleanOptional,
  IntegerOptional
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ModifyDbInstanceRequest(
    dbInstanceIdentifier: String,
    allocatedStorage: scala.Option[IntegerOptional] = None,
    dbInstanceClass: scala.Option[String] = None,
    dbSubnetGroupName: scala.Option[String] = None,
    dbSecurityGroups: scala.Option[Iterable[String]] = None,
    vpcSecurityGroupIds: scala.Option[Iterable[String]] = None,
    applyImmediately: scala.Option[Boolean] = None,
    masterUserPassword: scala.Option[String] = None,
    dbParameterGroupName: scala.Option[String] = None,
    backupRetentionPeriod: scala.Option[IntegerOptional] = None,
    preferredBackupWindow: scala.Option[String] = None,
    preferredMaintenanceWindow: scala.Option[String] = None,
    multiAZ: scala.Option[BooleanOptional] = None,
    engineVersion: scala.Option[String] = None,
    allowMajorVersionUpgrade: scala.Option[Boolean] = None,
    autoMinorVersionUpgrade: scala.Option[BooleanOptional] = None,
    licenseModel: scala.Option[String] = None,
    iops: scala.Option[IntegerOptional] = None,
    optionGroupName: scala.Option[String] = None,
    newDBInstanceIdentifier: scala.Option[String] = None,
    storageType: scala.Option[String] = None,
    tdeCredentialArn: scala.Option[String] = None,
    tdeCredentialPassword: scala.Option[String] = None,
    caCertificateIdentifier: scala.Option[String] = None,
    domain: scala.Option[String] = None,
    copyTagsToSnapshot: scala.Option[BooleanOptional] = None,
    monitoringInterval: scala.Option[IntegerOptional] = None,
    dbPortNumber: scala.Option[IntegerOptional] = None,
    publiclyAccessible: scala.Option[BooleanOptional] = None,
    monitoringRoleArn: scala.Option[String] = None,
    domainIAMRoleName: scala.Option[String] = None,
    promotionTier: scala.Option[IntegerOptional] = None,
    enableIAMDatabaseAuthentication: scala.Option[BooleanOptional] = None,
    enablePerformanceInsights: scala.Option[BooleanOptional] = None,
    performanceInsightsKMSKeyId: scala.Option[String] = None,
    performanceInsightsRetentionPeriod: scala.Option[IntegerOptional] = None,
    cloudwatchLogsExportConfiguration: scala.Option[
      zio.aws.rds.model.CloudwatchLogsExportConfiguration
    ] = None,
    processorFeatures: scala.Option[Iterable[
      zio.aws.rds.model.ProcessorFeature
    ]] = None,
    useDefaultProcessorFeatures: scala.Option[BooleanOptional] = None,
    deletionProtection: scala.Option[BooleanOptional] = None,
    maxAllocatedStorage: scala.Option[IntegerOptional] = None,
    certificateRotationRestart: scala.Option[BooleanOptional] = None,
    replicaMode: scala.Option[zio.aws.rds.model.ReplicaMode] = None,
    enableCustomerOwnedIp: scala.Option[BooleanOptional] = None,
    awsBackupRecoveryPointArn: scala.Option[AwsBackupRecoveryPointArn] = None,
    automationMode: scala.Option[zio.aws.rds.model.AutomationMode] = None,
    resumeFullAutomationModeMinutes: scala.Option[IntegerOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ModifyDbInstanceRequest = {
    import ModifyDbInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ModifyDbInstanceRequest
      .builder()
      .dbInstanceIdentifier(dbInstanceIdentifier: java.lang.String)
      .optionallyWith(allocatedStorage.map(value => value: Integer))(
        _.allocatedStorage
      )
      .optionallyWith(dbInstanceClass.map(value => value: java.lang.String))(
        _.dbInstanceClass
      )
      .optionallyWith(dbSubnetGroupName.map(value => value: java.lang.String))(
        _.dbSubnetGroupName
      )
      .optionallyWith(
        dbSecurityGroups.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.dbSecurityGroups)
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .optionallyWith(applyImmediately.map(value => value: java.lang.Boolean))(
        _.applyImmediately
      )
      .optionallyWith(masterUserPassword.map(value => value: java.lang.String))(
        _.masterUserPassword
      )
      .optionallyWith(
        dbParameterGroupName.map(value => value: java.lang.String)
      )(_.dbParameterGroupName)
      .optionallyWith(backupRetentionPeriod.map(value => value: Integer))(
        _.backupRetentionPeriod
      )
      .optionallyWith(
        preferredBackupWindow.map(value => value: java.lang.String)
      )(_.preferredBackupWindow)
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(multiAZ.map(value => value: java.lang.Boolean))(_.multiAZ)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        allowMajorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.allowMajorVersionUpgrade)
      .optionallyWith(
        autoMinorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.autoMinorVersionUpgrade)
      .optionallyWith(licenseModel.map(value => value: java.lang.String))(
        _.licenseModel
      )
      .optionallyWith(iops.map(value => value: Integer))(_.iops)
      .optionallyWith(optionGroupName.map(value => value: java.lang.String))(
        _.optionGroupName
      )
      .optionallyWith(
        newDBInstanceIdentifier.map(value => value: java.lang.String)
      )(_.newDBInstanceIdentifier)
      .optionallyWith(storageType.map(value => value: java.lang.String))(
        _.storageType
      )
      .optionallyWith(tdeCredentialArn.map(value => value: java.lang.String))(
        _.tdeCredentialArn
      )
      .optionallyWith(
        tdeCredentialPassword.map(value => value: java.lang.String)
      )(_.tdeCredentialPassword)
      .optionallyWith(
        caCertificateIdentifier.map(value => value: java.lang.String)
      )(_.caCertificateIdentifier)
      .optionallyWith(domain.map(value => value: java.lang.String))(_.domain)
      .optionallyWith(
        copyTagsToSnapshot.map(value => value: java.lang.Boolean)
      )(_.copyTagsToSnapshot)
      .optionallyWith(monitoringInterval.map(value => value: Integer))(
        _.monitoringInterval
      )
      .optionallyWith(dbPortNumber.map(value => value: Integer))(_.dbPortNumber)
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(monitoringRoleArn.map(value => value: java.lang.String))(
        _.monitoringRoleArn
      )
      .optionallyWith(domainIAMRoleName.map(value => value: java.lang.String))(
        _.domainIAMRoleName
      )
      .optionallyWith(promotionTier.map(value => value: Integer))(
        _.promotionTier
      )
      .optionallyWith(
        enableIAMDatabaseAuthentication.map(value => value: java.lang.Boolean)
      )(_.enableIAMDatabaseAuthentication)
      .optionallyWith(
        enablePerformanceInsights.map(value => value: java.lang.Boolean)
      )(_.enablePerformanceInsights)
      .optionallyWith(
        performanceInsightsKMSKeyId.map(value => value: java.lang.String)
      )(_.performanceInsightsKMSKeyId)
      .optionallyWith(
        performanceInsightsRetentionPeriod.map(value => value: Integer)
      )(_.performanceInsightsRetentionPeriod)
      .optionallyWith(
        cloudwatchLogsExportConfiguration.map(value => value.buildAwsValue())
      )(_.cloudwatchLogsExportConfiguration)
      .optionallyWith(
        processorFeatures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processorFeatures)
      .optionallyWith(
        useDefaultProcessorFeatures.map(value => value: java.lang.Boolean)
      )(_.useDefaultProcessorFeatures)
      .optionallyWith(
        deletionProtection.map(value => value: java.lang.Boolean)
      )(_.deletionProtection)
      .optionallyWith(maxAllocatedStorage.map(value => value: Integer))(
        _.maxAllocatedStorage
      )
      .optionallyWith(
        certificateRotationRestart.map(value => value: java.lang.Boolean)
      )(_.certificateRotationRestart)
      .optionallyWith(replicaMode.map(value => value.unwrap))(_.replicaMode)
      .optionallyWith(
        enableCustomerOwnedIp.map(value => value: java.lang.Boolean)
      )(_.enableCustomerOwnedIp)
      .optionallyWith(
        awsBackupRecoveryPointArn.map(value =>
          AwsBackupRecoveryPointArn.unwrap(value): java.lang.String
        )
      )(_.awsBackupRecoveryPointArn)
      .optionallyWith(automationMode.map(value => value.unwrap))(
        _.automationMode
      )
      .optionallyWith(
        resumeFullAutomationModeMinutes.map(value => value: Integer)
      )(_.resumeFullAutomationModeMinutes)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ModifyDbInstanceRequest.ReadOnly =
    zio.aws.rds.model.ModifyDbInstanceRequest.wrap(buildAwsValue())
}
object ModifyDbInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ModifyDbInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ModifyDbInstanceRequest =
      zio.aws.rds.model.ModifyDbInstanceRequest(
        dbInstanceIdentifier,
        allocatedStorage.map(value => value),
        dbInstanceClass.map(value => value),
        dbSubnetGroupName.map(value => value),
        dbSecurityGroups.map(value => value),
        vpcSecurityGroupIds.map(value => value),
        applyImmediately.map(value => value),
        masterUserPassword.map(value => value),
        dbParameterGroupName.map(value => value),
        backupRetentionPeriod.map(value => value),
        preferredBackupWindow.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        multiAZ.map(value => value),
        engineVersion.map(value => value),
        allowMajorVersionUpgrade.map(value => value),
        autoMinorVersionUpgrade.map(value => value),
        licenseModel.map(value => value),
        iops.map(value => value),
        optionGroupName.map(value => value),
        newDBInstanceIdentifier.map(value => value),
        storageType.map(value => value),
        tdeCredentialArn.map(value => value),
        tdeCredentialPassword.map(value => value),
        caCertificateIdentifier.map(value => value),
        domain.map(value => value),
        copyTagsToSnapshot.map(value => value),
        monitoringInterval.map(value => value),
        dbPortNumber.map(value => value),
        publiclyAccessible.map(value => value),
        monitoringRoleArn.map(value => value),
        domainIAMRoleName.map(value => value),
        promotionTier.map(value => value),
        enableIAMDatabaseAuthentication.map(value => value),
        enablePerformanceInsights.map(value => value),
        performanceInsightsKMSKeyId.map(value => value),
        performanceInsightsRetentionPeriod.map(value => value),
        cloudwatchLogsExportConfiguration.map(value => value.asEditable),
        processorFeatures.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        useDefaultProcessorFeatures.map(value => value),
        deletionProtection.map(value => value),
        maxAllocatedStorage.map(value => value),
        certificateRotationRestart.map(value => value),
        replicaMode.map(value => value),
        enableCustomerOwnedIp.map(value => value),
        awsBackupRecoveryPointArn.map(value => value),
        automationMode.map(value => value),
        resumeFullAutomationModeMinutes.map(value => value)
      )
    def dbInstanceIdentifier: String
    def allocatedStorage: scala.Option[IntegerOptional]
    def dbInstanceClass: scala.Option[String]
    def dbSubnetGroupName: scala.Option[String]
    def dbSecurityGroups: scala.Option[List[String]]
    def vpcSecurityGroupIds: scala.Option[List[String]]
    def applyImmediately: scala.Option[Boolean]
    def masterUserPassword: scala.Option[String]
    def dbParameterGroupName: scala.Option[String]
    def backupRetentionPeriod: scala.Option[IntegerOptional]
    def preferredBackupWindow: scala.Option[String]
    def preferredMaintenanceWindow: scala.Option[String]
    def multiAZ: scala.Option[BooleanOptional]
    def engineVersion: scala.Option[String]
    def allowMajorVersionUpgrade: scala.Option[Boolean]
    def autoMinorVersionUpgrade: scala.Option[BooleanOptional]
    def licenseModel: scala.Option[String]
    def iops: scala.Option[IntegerOptional]
    def optionGroupName: scala.Option[String]
    def newDBInstanceIdentifier: scala.Option[String]
    def storageType: scala.Option[String]
    def tdeCredentialArn: scala.Option[String]
    def tdeCredentialPassword: scala.Option[String]
    def caCertificateIdentifier: scala.Option[String]
    def domain: scala.Option[String]
    def copyTagsToSnapshot: scala.Option[BooleanOptional]
    def monitoringInterval: scala.Option[IntegerOptional]
    def dbPortNumber: scala.Option[IntegerOptional]
    def publiclyAccessible: scala.Option[BooleanOptional]
    def monitoringRoleArn: scala.Option[String]
    def domainIAMRoleName: scala.Option[String]
    def promotionTier: scala.Option[IntegerOptional]
    def enableIAMDatabaseAuthentication: scala.Option[BooleanOptional]
    def enablePerformanceInsights: scala.Option[BooleanOptional]
    def performanceInsightsKMSKeyId: scala.Option[String]
    def performanceInsightsRetentionPeriod: scala.Option[IntegerOptional]
    def cloudwatchLogsExportConfiguration: scala.Option[
      zio.aws.rds.model.CloudwatchLogsExportConfiguration.ReadOnly
    ]
    def processorFeatures
        : scala.Option[List[zio.aws.rds.model.ProcessorFeature.ReadOnly]]
    def useDefaultProcessorFeatures: scala.Option[BooleanOptional]
    def deletionProtection: scala.Option[BooleanOptional]
    def maxAllocatedStorage: scala.Option[IntegerOptional]
    def certificateRotationRestart: scala.Option[BooleanOptional]
    def replicaMode: scala.Option[zio.aws.rds.model.ReplicaMode]
    def enableCustomerOwnedIp: scala.Option[BooleanOptional]
    def awsBackupRecoveryPointArn: scala.Option[AwsBackupRecoveryPointArn]
    def automationMode: scala.Option[zio.aws.rds.model.AutomationMode]
    def resumeFullAutomationModeMinutes: scala.Option[IntegerOptional]
    def getDbInstanceIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbInstanceIdentifier)
    def getAllocatedStorage: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getDbInstanceClass: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceClass", dbInstanceClass)
    def getDbSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSubnetGroupName", dbSubnetGroupName)
    def getDbSecurityGroups: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("dbSecurityGroups", dbSecurityGroups)
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
    def getApplyImmediately: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("applyImmediately", applyImmediately)
    def getMasterUserPassword: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUserPassword", masterUserPassword)
    def getDbParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbParameterGroupName", dbParameterGroupName)
    def getBackupRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriod)
    def getPreferredBackupWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindow)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getMultiAZ: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("multiAZ", multiAZ)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getAllowMajorVersionUpgrade: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("allowMajorVersionUpgrade", allowMajorVersionUpgrade)
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "autoMinorVersionUpgrade",
        autoMinorVersionUpgrade
      )
    def getLicenseModel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("licenseModel", licenseModel)
    def getIops: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("iops", iops)
    def getOptionGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optionGroupName", optionGroupName)
    def getNewDBInstanceIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("newDBInstanceIdentifier", newDBInstanceIdentifier)
    def getStorageType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getTdeCredentialArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tdeCredentialArn", tdeCredentialArn)
    def getTdeCredentialPassword: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tdeCredentialPassword", tdeCredentialPassword)
    def getCaCertificateIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("caCertificateIdentifier", caCertificateIdentifier)
    def getDomain: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domain", domain)
    def getCopyTagsToSnapshot: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("copyTagsToSnapshot", copyTagsToSnapshot)
    def getMonitoringInterval: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("monitoringInterval", monitoringInterval)
    def getDbPortNumber: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("dbPortNumber", dbPortNumber)
    def getPubliclyAccessible: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getMonitoringRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("monitoringRoleArn", monitoringRoleArn)
    def getDomainIAMRoleName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domainIAMRoleName", domainIAMRoleName)
    def getPromotionTier: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("promotionTier", promotionTier)
    def getEnableIAMDatabaseAuthentication
        : ZIO[Any, AwsError, BooleanOptional] = AwsError.unwrapOptionField(
      "enableIAMDatabaseAuthentication",
      enableIAMDatabaseAuthentication
    )
    def getEnablePerformanceInsights: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "enablePerformanceInsights",
        enablePerformanceInsights
      )
    def getPerformanceInsightsKMSKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "performanceInsightsKMSKeyId",
        performanceInsightsKMSKeyId
      )
    def getPerformanceInsightsRetentionPeriod
        : ZIO[Any, AwsError, IntegerOptional] = AwsError.unwrapOptionField(
      "performanceInsightsRetentionPeriod",
      performanceInsightsRetentionPeriod
    )
    def getCloudwatchLogsExportConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.rds.model.CloudwatchLogsExportConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudwatchLogsExportConfiguration",
      cloudwatchLogsExportConfiguration
    )
    def getProcessorFeatures: ZIO[Any, AwsError, List[
      zio.aws.rds.model.ProcessorFeature.ReadOnly
    ]] = AwsError.unwrapOptionField("processorFeatures", processorFeatures)
    def getUseDefaultProcessorFeatures: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "useDefaultProcessorFeatures",
        useDefaultProcessorFeatures
      )
    def getDeletionProtection: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
    def getMaxAllocatedStorage: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxAllocatedStorage", maxAllocatedStorage)
    def getCertificateRotationRestart: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "certificateRotationRestart",
        certificateRotationRestart
      )
    def getReplicaMode: ZIO[Any, AwsError, zio.aws.rds.model.ReplicaMode] =
      AwsError.unwrapOptionField("replicaMode", replicaMode)
    def getEnableCustomerOwnedIp: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("enableCustomerOwnedIp", enableCustomerOwnedIp)
    def getAwsBackupRecoveryPointArn
        : ZIO[Any, AwsError, AwsBackupRecoveryPointArn] = AwsError
      .unwrapOptionField("awsBackupRecoveryPointArn", awsBackupRecoveryPointArn)
    def getAutomationMode
        : ZIO[Any, AwsError, zio.aws.rds.model.AutomationMode] =
      AwsError.unwrapOptionField("automationMode", automationMode)
    def getResumeFullAutomationModeMinutes
        : ZIO[Any, AwsError, IntegerOptional] = AwsError.unwrapOptionField(
      "resumeFullAutomationModeMinutes",
      resumeFullAutomationModeMinutes
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ModifyDbInstanceRequest
  ) extends zio.aws.rds.model.ModifyDbInstanceRequest.ReadOnly {
    override val dbInstanceIdentifier: String =
      impl.dbInstanceIdentifier(): String
    override val allocatedStorage: scala.Option[IntegerOptional] =
      scala.Option(impl.allocatedStorage()).map(value => value: IntegerOptional)
    override val dbInstanceClass: scala.Option[String] =
      scala.Option(impl.dbInstanceClass()).map(value => value: String)
    override val dbSubnetGroupName: scala.Option[String] =
      scala.Option(impl.dbSubnetGroupName()).map(value => value: String)
    override val dbSecurityGroups: scala.Option[List[String]] = scala
      .Option(impl.dbSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val vpcSecurityGroupIds: scala.Option[List[String]] = scala
      .Option(impl.vpcSecurityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val applyImmediately: scala.Option[Boolean] =
      scala.Option(impl.applyImmediately()).map(value => value: Boolean)
    override val masterUserPassword: scala.Option[String] =
      scala.Option(impl.masterUserPassword()).map(value => value: String)
    override val dbParameterGroupName: scala.Option[String] =
      scala.Option(impl.dbParameterGroupName()).map(value => value: String)
    override val backupRetentionPeriod: scala.Option[IntegerOptional] = scala
      .Option(impl.backupRetentionPeriod())
      .map(value => value: IntegerOptional)
    override val preferredBackupWindow: scala.Option[String] =
      scala.Option(impl.preferredBackupWindow()).map(value => value: String)
    override val preferredMaintenanceWindow: scala.Option[String] = scala
      .Option(impl.preferredMaintenanceWindow())
      .map(value => value: String)
    override val multiAZ: scala.Option[BooleanOptional] =
      scala.Option(impl.multiAZ()).map(value => value: BooleanOptional)
    override val engineVersion: scala.Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val allowMajorVersionUpgrade: scala.Option[Boolean] =
      scala.Option(impl.allowMajorVersionUpgrade()).map(value => value: Boolean)
    override val autoMinorVersionUpgrade: scala.Option[BooleanOptional] = scala
      .Option(impl.autoMinorVersionUpgrade())
      .map(value => value: BooleanOptional)
    override val licenseModel: scala.Option[String] =
      scala.Option(impl.licenseModel()).map(value => value: String)
    override val iops: scala.Option[IntegerOptional] =
      scala.Option(impl.iops()).map(value => value: IntegerOptional)
    override val optionGroupName: scala.Option[String] =
      scala.Option(impl.optionGroupName()).map(value => value: String)
    override val newDBInstanceIdentifier: scala.Option[String] =
      scala.Option(impl.newDBInstanceIdentifier()).map(value => value: String)
    override val storageType: scala.Option[String] =
      scala.Option(impl.storageType()).map(value => value: String)
    override val tdeCredentialArn: scala.Option[String] =
      scala.Option(impl.tdeCredentialArn()).map(value => value: String)
    override val tdeCredentialPassword: scala.Option[String] =
      scala.Option(impl.tdeCredentialPassword()).map(value => value: String)
    override val caCertificateIdentifier: scala.Option[String] =
      scala.Option(impl.caCertificateIdentifier()).map(value => value: String)
    override val domain: scala.Option[String] =
      scala.Option(impl.domain()).map(value => value: String)
    override val copyTagsToSnapshot: scala.Option[BooleanOptional] = scala
      .Option(impl.copyTagsToSnapshot())
      .map(value => value: BooleanOptional)
    override val monitoringInterval: scala.Option[IntegerOptional] = scala
      .Option(impl.monitoringInterval())
      .map(value => value: IntegerOptional)
    override val dbPortNumber: scala.Option[IntegerOptional] =
      scala.Option(impl.dbPortNumber()).map(value => value: IntegerOptional)
    override val publiclyAccessible: scala.Option[BooleanOptional] = scala
      .Option(impl.publiclyAccessible())
      .map(value => value: BooleanOptional)
    override val monitoringRoleArn: scala.Option[String] =
      scala.Option(impl.monitoringRoleArn()).map(value => value: String)
    override val domainIAMRoleName: scala.Option[String] =
      scala.Option(impl.domainIAMRoleName()).map(value => value: String)
    override val promotionTier: scala.Option[IntegerOptional] =
      scala.Option(impl.promotionTier()).map(value => value: IntegerOptional)
    override val enableIAMDatabaseAuthentication
        : scala.Option[BooleanOptional] = scala
      .Option(impl.enableIAMDatabaseAuthentication())
      .map(value => value: BooleanOptional)
    override val enablePerformanceInsights: scala.Option[BooleanOptional] =
      scala
        .Option(impl.enablePerformanceInsights())
        .map(value => value: BooleanOptional)
    override val performanceInsightsKMSKeyId: scala.Option[String] = scala
      .Option(impl.performanceInsightsKMSKeyId())
      .map(value => value: String)
    override val performanceInsightsRetentionPeriod
        : scala.Option[IntegerOptional] = scala
      .Option(impl.performanceInsightsRetentionPeriod())
      .map(value => value: IntegerOptional)
    override val cloudwatchLogsExportConfiguration: scala.Option[
      zio.aws.rds.model.CloudwatchLogsExportConfiguration.ReadOnly
    ] = scala
      .Option(impl.cloudwatchLogsExportConfiguration())
      .map(value =>
        zio.aws.rds.model.CloudwatchLogsExportConfiguration.wrap(value)
      )
    override val processorFeatures
        : scala.Option[List[zio.aws.rds.model.ProcessorFeature.ReadOnly]] =
      scala
        .Option(impl.processorFeatures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.ProcessorFeature.wrap(item)
          }.toList
        )
    override val useDefaultProcessorFeatures: scala.Option[BooleanOptional] =
      scala
        .Option(impl.useDefaultProcessorFeatures())
        .map(value => value: BooleanOptional)
    override val deletionProtection: scala.Option[BooleanOptional] = scala
      .Option(impl.deletionProtection())
      .map(value => value: BooleanOptional)
    override val maxAllocatedStorage: scala.Option[IntegerOptional] = scala
      .Option(impl.maxAllocatedStorage())
      .map(value => value: IntegerOptional)
    override val certificateRotationRestart: scala.Option[BooleanOptional] =
      scala
        .Option(impl.certificateRotationRestart())
        .map(value => value: BooleanOptional)
    override val replicaMode: scala.Option[zio.aws.rds.model.ReplicaMode] =
      scala
        .Option(impl.replicaMode())
        .map(value => zio.aws.rds.model.ReplicaMode.wrap(value))
    override val enableCustomerOwnedIp: scala.Option[BooleanOptional] = scala
      .Option(impl.enableCustomerOwnedIp())
      .map(value => value: BooleanOptional)
    override val awsBackupRecoveryPointArn
        : scala.Option[AwsBackupRecoveryPointArn] = scala
      .Option(impl.awsBackupRecoveryPointArn())
      .map(value =>
        zio.aws.rds.model.primitives.AwsBackupRecoveryPointArn(value)
      )
    override val automationMode
        : scala.Option[zio.aws.rds.model.AutomationMode] = scala
      .Option(impl.automationMode())
      .map(value => zio.aws.rds.model.AutomationMode.wrap(value))
    override val resumeFullAutomationModeMinutes
        : scala.Option[IntegerOptional] = scala
      .Option(impl.resumeFullAutomationModeMinutes())
      .map(value => value: IntegerOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ModifyDbInstanceRequest
  ): zio.aws.rds.model.ModifyDbInstanceRequest.ReadOnly = new Wrapper(impl)
}
