package zio.aws.rds.model
import zio.aws.rds.model.primitives.BooleanOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ModifyCertificatesRequest(
    certificateIdentifier: scala.Option[String] = None,
    removeCustomerOverride: scala.Option[BooleanOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ModifyCertificatesRequest = {
    import ModifyCertificatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ModifyCertificatesRequest
      .builder()
      .optionallyWith(
        certificateIdentifier.map(value => value: java.lang.String)
      )(_.certificateIdentifier)
      .optionallyWith(
        removeCustomerOverride.map(value => value: java.lang.Boolean)
      )(_.removeCustomerOverride)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ModifyCertificatesRequest.ReadOnly =
    zio.aws.rds.model.ModifyCertificatesRequest.wrap(buildAwsValue())
}
object ModifyCertificatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ModifyCertificatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ModifyCertificatesRequest =
      zio.aws.rds.model.ModifyCertificatesRequest(
        certificateIdentifier.map(value => value),
        removeCustomerOverride.map(value => value)
      )
    def certificateIdentifier: scala.Option[String]
    def removeCustomerOverride: scala.Option[BooleanOptional]
    def getCertificateIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificateIdentifier", certificateIdentifier)
    def getRemoveCustomerOverride: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "removeCustomerOverride",
        removeCustomerOverride
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ModifyCertificatesRequest
  ) extends zio.aws.rds.model.ModifyCertificatesRequest.ReadOnly {
    override val certificateIdentifier: scala.Option[String] =
      scala.Option(impl.certificateIdentifier()).map(value => value: String)
    override val removeCustomerOverride: scala.Option[BooleanOptional] = scala
      .Option(impl.removeCustomerOverride())
      .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ModifyCertificatesRequest
  ): zio.aws.rds.model.ModifyCertificatesRequest.ReadOnly = new Wrapper(impl)
}
