package zio.aws.rds.model
import zio.aws.rds.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Endpoint(
    address: scala.Option[String] = None,
    port: scala.Option[Integer] = None,
    hostedZoneId: scala.Option[String] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.rds.model.Endpoint = {
    import Endpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.Endpoint
      .builder()
      .optionallyWith(address.map(value => value: java.lang.String))(_.address)
      .optionallyWith(port.map(value => value: java.lang.Integer))(_.port)
      .optionallyWith(hostedZoneId.map(value => value: java.lang.String))(
        _.hostedZoneId
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.Endpoint.ReadOnly =
    zio.aws.rds.model.Endpoint.wrap(buildAwsValue())
}
object Endpoint {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.Endpoint] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.Endpoint = zio.aws.rds.model.Endpoint(
      address.map(value => value),
      port.map(value => value),
      hostedZoneId.map(value => value)
    )
    def address: scala.Option[String]
    def port: scala.Option[Integer]
    def hostedZoneId: scala.Option[String]
    def getAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("address", address)
    def getPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("port", port)
    def getHostedZoneId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hostedZoneId", hostedZoneId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.Endpoint
  ) extends zio.aws.rds.model.Endpoint.ReadOnly {
    override val address: scala.Option[String] =
      scala.Option(impl.address()).map(value => value: String)
    override val port: scala.Option[Integer] =
      scala.Option(impl.port()).map(value => value: Integer)
    override val hostedZoneId: scala.Option[String] =
      scala.Option(impl.hostedZoneId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.Endpoint
  ): zio.aws.rds.model.Endpoint.ReadOnly = new Wrapper(impl)
}
