package zio.aws.rds.model
import zio.aws.rds.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DownloadDbLogFilePortionRequest(
    dbInstanceIdentifier: String,
    logFileName: String,
    marker: scala.Option[String] = None,
    numberOfLines: scala.Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DownloadDbLogFilePortionRequest = {
    import DownloadDbLogFilePortionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DownloadDbLogFilePortionRequest
      .builder()
      .dbInstanceIdentifier(dbInstanceIdentifier: java.lang.String)
      .logFileName(logFileName: java.lang.String)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(numberOfLines.map(value => value: java.lang.Integer))(
        _.numberOfLines
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DownloadDbLogFilePortionRequest.ReadOnly =
    zio.aws.rds.model.DownloadDbLogFilePortionRequest.wrap(buildAwsValue())
}
object DownloadDbLogFilePortionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DownloadDbLogFilePortionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DownloadDbLogFilePortionRequest =
      zio.aws.rds.model.DownloadDbLogFilePortionRequest(
        dbInstanceIdentifier,
        logFileName,
        marker.map(value => value),
        numberOfLines.map(value => value)
      )
    def dbInstanceIdentifier: String
    def logFileName: String
    def marker: scala.Option[String]
    def numberOfLines: scala.Option[Integer]
    def getDbInstanceIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbInstanceIdentifier)
    def getLogFileName: ZIO[Any, Nothing, String] = ZIO.succeed(logFileName)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getNumberOfLines: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("numberOfLines", numberOfLines)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DownloadDbLogFilePortionRequest
  ) extends zio.aws.rds.model.DownloadDbLogFilePortionRequest.ReadOnly {
    override val dbInstanceIdentifier: String =
      impl.dbInstanceIdentifier(): String
    override val logFileName: String = impl.logFileName(): String
    override val marker: scala.Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val numberOfLines: scala.Option[Integer] =
      scala.Option(impl.numberOfLines()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DownloadDbLogFilePortionRequest
  ): zio.aws.rds.model.DownloadDbLogFilePortionRequest.ReadOnly = new Wrapper(
    impl
  )
}
