package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribePendingMaintenanceActionsResponse(
    pendingMaintenanceActions: scala.Option[Iterable[
      zio.aws.rds.model.ResourcePendingMaintenanceActions
    ]] = None,
    marker: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsResponse = {
    import DescribePendingMaintenanceActionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsResponse
      .builder()
      .optionallyWith(
        pendingMaintenanceActions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pendingMaintenanceActions)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.DescribePendingMaintenanceActionsResponse.ReadOnly =
    zio.aws.rds.model.DescribePendingMaintenanceActionsResponse
      .wrap(buildAwsValue())
}
object DescribePendingMaintenanceActionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.rds.model.DescribePendingMaintenanceActionsResponse =
      zio.aws.rds.model.DescribePendingMaintenanceActionsResponse(
        pendingMaintenanceActions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def pendingMaintenanceActions: scala.Option[List[
      zio.aws.rds.model.ResourcePendingMaintenanceActions.ReadOnly
    ]]
    def marker: scala.Option[String]
    def getPendingMaintenanceActions: ZIO[Any, AwsError, List[
      zio.aws.rds.model.ResourcePendingMaintenanceActions.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "pendingMaintenanceActions",
      pendingMaintenanceActions
    )
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsResponse
  ) extends zio.aws.rds.model.DescribePendingMaintenanceActionsResponse.ReadOnly {
    override val pendingMaintenanceActions: scala.Option[List[
      zio.aws.rds.model.ResourcePendingMaintenanceActions.ReadOnly
    ]] = scala
      .Option(impl.pendingMaintenanceActions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.ResourcePendingMaintenanceActions.wrap(item)
        }.toList
      )
    override val marker: scala.Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsResponse
  ): zio.aws.rds.model.DescribePendingMaintenanceActionsResponse.ReadOnly =
    new Wrapper(impl)
}
