package zio.aws.rds.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.{IntegerOptional, TStamp}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeEventsRequest(
    sourceIdentifier: scala.Option[String] = None,
    sourceType: scala.Option[zio.aws.rds.model.SourceType] = None,
    startTime: scala.Option[TStamp] = None,
    endTime: scala.Option[TStamp] = None,
    duration: scala.Option[IntegerOptional] = None,
    eventCategories: scala.Option[Iterable[String]] = None,
    filters: scala.Option[Iterable[zio.aws.rds.model.Filter]] = None,
    maxRecords: scala.Option[IntegerOptional] = None,
    marker: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeEventsRequest = {
    import DescribeEventsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeEventsRequest
      .builder()
      .optionallyWith(sourceIdentifier.map(value => value: java.lang.String))(
        _.sourceIdentifier
      )
      .optionallyWith(sourceType.map(value => value.unwrap))(_.sourceType)
      .optionallyWith(startTime.map(value => TStamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => TStamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(duration.map(value => value: Integer))(_.duration)
      .optionallyWith(
        eventCategories.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.eventCategories)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DescribeEventsRequest.ReadOnly =
    zio.aws.rds.model.DescribeEventsRequest.wrap(buildAwsValue())
}
object DescribeEventsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeEventsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeEventsRequest =
      zio.aws.rds.model.DescribeEventsRequest(
        sourceIdentifier.map(value => value),
        sourceType.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        duration.map(value => value),
        eventCategories.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def sourceIdentifier: scala.Option[String]
    def sourceType: scala.Option[zio.aws.rds.model.SourceType]
    def startTime: scala.Option[TStamp]
    def endTime: scala.Option[TStamp]
    def duration: scala.Option[IntegerOptional]
    def eventCategories: scala.Option[List[String]]
    def filters: scala.Option[List[zio.aws.rds.model.Filter.ReadOnly]]
    def maxRecords: scala.Option[IntegerOptional]
    def marker: scala.Option[String]
    def getSourceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceIdentifier", sourceIdentifier)
    def getSourceType: ZIO[Any, AwsError, zio.aws.rds.model.SourceType] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getStartTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getDuration: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("duration", duration)
    def getEventCategories: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("eventCategories", eventCategories)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.rds.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeEventsRequest
  ) extends zio.aws.rds.model.DescribeEventsRequest.ReadOnly {
    override val sourceIdentifier: scala.Option[String] =
      scala.Option(impl.sourceIdentifier()).map(value => value: String)
    override val sourceType: scala.Option[zio.aws.rds.model.SourceType] = scala
      .Option(impl.sourceType())
      .map(value => zio.aws.rds.model.SourceType.wrap(value))
    override val startTime: scala.Option[TStamp] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val endTime: scala.Option[TStamp] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val duration: scala.Option[IntegerOptional] =
      scala.Option(impl.duration()).map(value => value: IntegerOptional)
    override val eventCategories: scala.Option[List[String]] = scala
      .Option(impl.eventCategories())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val filters
        : scala.Option[List[zio.aws.rds.model.Filter.ReadOnly]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.Filter.wrap(item)
        }.toList
      )
    override val maxRecords: scala.Option[IntegerOptional] =
      scala.Option(impl.maxRecords()).map(value => value: IntegerOptional)
    override val marker: scala.Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeEventsRequest
  ): zio.aws.rds.model.DescribeEventsRequest.ReadOnly = new Wrapper(impl)
}
