package zio.aws.rds.model
import java.lang.Integer
import zio.aws.rds.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeDbInstanceAutomatedBackupsRequest(
    dbiResourceId: scala.Option[String] = None,
    dbInstanceIdentifier: scala.Option[String] = None,
    filters: scala.Option[Iterable[zio.aws.rds.model.Filter]] = None,
    maxRecords: scala.Option[IntegerOptional] = None,
    marker: scala.Option[String] = None,
    dbInstanceAutomatedBackupsArn: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsRequest = {
    import DescribeDbInstanceAutomatedBackupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsRequest
      .builder()
      .optionallyWith(dbiResourceId.map(value => value: java.lang.String))(
        _.dbiResourceId
      )
      .optionallyWith(
        dbInstanceIdentifier.map(value => value: java.lang.String)
      )(_.dbInstanceIdentifier)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        dbInstanceAutomatedBackupsArn.map(value => value: java.lang.String)
      )(_.dbInstanceAutomatedBackupsArn)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.DescribeDbInstanceAutomatedBackupsRequest.ReadOnly =
    zio.aws.rds.model.DescribeDbInstanceAutomatedBackupsRequest
      .wrap(buildAwsValue())
}
object DescribeDbInstanceAutomatedBackupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.rds.model.DescribeDbInstanceAutomatedBackupsRequest =
      zio.aws.rds.model.DescribeDbInstanceAutomatedBackupsRequest(
        dbiResourceId.map(value => value),
        dbInstanceIdentifier.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxRecords.map(value => value),
        marker.map(value => value),
        dbInstanceAutomatedBackupsArn.map(value => value)
      )
    def dbiResourceId: scala.Option[String]
    def dbInstanceIdentifier: scala.Option[String]
    def filters: scala.Option[List[zio.aws.rds.model.Filter.ReadOnly]]
    def maxRecords: scala.Option[IntegerOptional]
    def marker: scala.Option[String]
    def dbInstanceAutomatedBackupsArn: scala.Option[String]
    def getDbiResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbiResourceId", dbiResourceId)
    def getDbInstanceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceIdentifier", dbInstanceIdentifier)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.rds.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getDbInstanceAutomatedBackupsArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbInstanceAutomatedBackupsArn",
        dbInstanceAutomatedBackupsArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsRequest
  ) extends zio.aws.rds.model.DescribeDbInstanceAutomatedBackupsRequest.ReadOnly {
    override val dbiResourceId: scala.Option[String] =
      scala.Option(impl.dbiResourceId()).map(value => value: String)
    override val dbInstanceIdentifier: scala.Option[String] =
      scala.Option(impl.dbInstanceIdentifier()).map(value => value: String)
    override val filters
        : scala.Option[List[zio.aws.rds.model.Filter.ReadOnly]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.Filter.wrap(item)
        }.toList
      )
    override val maxRecords: scala.Option[IntegerOptional] =
      scala.Option(impl.maxRecords()).map(value => value: IntegerOptional)
    override val marker: scala.Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val dbInstanceAutomatedBackupsArn: scala.Option[String] = scala
      .Option(impl.dbInstanceAutomatedBackupsArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsRequest
  ): zio.aws.rds.model.DescribeDbInstanceAutomatedBackupsRequest.ReadOnly =
    new Wrapper(impl)
}
