package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteGlobalClusterResponse(
    globalCluster: scala.Option[zio.aws.rds.model.GlobalCluster] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DeleteGlobalClusterResponse = {
    import DeleteGlobalClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DeleteGlobalClusterResponse
      .builder()
      .optionallyWith(globalCluster.map(value => value.buildAwsValue()))(
        _.globalCluster
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DeleteGlobalClusterResponse.ReadOnly =
    zio.aws.rds.model.DeleteGlobalClusterResponse.wrap(buildAwsValue())
}
object DeleteGlobalClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DeleteGlobalClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DeleteGlobalClusterResponse =
      zio.aws.rds.model.DeleteGlobalClusterResponse(
        globalCluster.map(value => value.asEditable)
      )
    def globalCluster: scala.Option[zio.aws.rds.model.GlobalCluster.ReadOnly]
    def getGlobalCluster
        : ZIO[Any, AwsError, zio.aws.rds.model.GlobalCluster.ReadOnly] =
      AwsError.unwrapOptionField("globalCluster", globalCluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DeleteGlobalClusterResponse
  ) extends zio.aws.rds.model.DeleteGlobalClusterResponse.ReadOnly {
    override val globalCluster
        : scala.Option[zio.aws.rds.model.GlobalCluster.ReadOnly] = scala
      .Option(impl.globalCluster())
      .map(value => zio.aws.rds.model.GlobalCluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DeleteGlobalClusterResponse
  ): zio.aws.rds.model.DeleteGlobalClusterResponse.ReadOnly = new Wrapper(impl)
}
