package zio.aws.rds.model
import zio.aws.rds.model.primitives.BooleanOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteDbInstanceRequest(
    dbInstanceIdentifier: String,
    skipFinalSnapshot: scala.Option[Boolean] = None,
    finalDBSnapshotIdentifier: scala.Option[String] = None,
    deleteAutomatedBackups: scala.Option[BooleanOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DeleteDbInstanceRequest = {
    import DeleteDbInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DeleteDbInstanceRequest
      .builder()
      .dbInstanceIdentifier(dbInstanceIdentifier: java.lang.String)
      .optionallyWith(skipFinalSnapshot.map(value => value: java.lang.Boolean))(
        _.skipFinalSnapshot
      )
      .optionallyWith(
        finalDBSnapshotIdentifier.map(value => value: java.lang.String)
      )(_.finalDBSnapshotIdentifier)
      .optionallyWith(
        deleteAutomatedBackups.map(value => value: java.lang.Boolean)
      )(_.deleteAutomatedBackups)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DeleteDbInstanceRequest.ReadOnly =
    zio.aws.rds.model.DeleteDbInstanceRequest.wrap(buildAwsValue())
}
object DeleteDbInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DeleteDbInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DeleteDbInstanceRequest =
      zio.aws.rds.model.DeleteDbInstanceRequest(
        dbInstanceIdentifier,
        skipFinalSnapshot.map(value => value),
        finalDBSnapshotIdentifier.map(value => value),
        deleteAutomatedBackups.map(value => value)
      )
    def dbInstanceIdentifier: String
    def skipFinalSnapshot: scala.Option[Boolean]
    def finalDBSnapshotIdentifier: scala.Option[String]
    def deleteAutomatedBackups: scala.Option[BooleanOptional]
    def getDbInstanceIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbInstanceIdentifier)
    def getSkipFinalSnapshot: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("skipFinalSnapshot", skipFinalSnapshot)
    def getFinalDBSnapshotIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("finalDBSnapshotIdentifier", finalDBSnapshotIdentifier)
    def getDeleteAutomatedBackups: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "deleteAutomatedBackups",
        deleteAutomatedBackups
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DeleteDbInstanceRequest
  ) extends zio.aws.rds.model.DeleteDbInstanceRequest.ReadOnly {
    override val dbInstanceIdentifier: String =
      impl.dbInstanceIdentifier(): String
    override val skipFinalSnapshot: scala.Option[Boolean] =
      scala.Option(impl.skipFinalSnapshot()).map(value => value: Boolean)
    override val finalDBSnapshotIdentifier: scala.Option[String] =
      scala.Option(impl.finalDBSnapshotIdentifier()).map(value => value: String)
    override val deleteAutomatedBackups: scala.Option[BooleanOptional] = scala
      .Option(impl.deleteAutomatedBackups())
      .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DeleteDbInstanceRequest
  ): zio.aws.rds.model.DeleteDbInstanceRequest.ReadOnly = new Wrapper(impl)
}
