package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DBSubnetGroup(
    dbSubnetGroupName: scala.Option[String] = None,
    dbSubnetGroupDescription: scala.Option[String] = None,
    vpcId: scala.Option[String] = None,
    subnetGroupStatus: scala.Option[String] = None,
    subnets: scala.Option[Iterable[zio.aws.rds.model.Subnet]] = None,
    dbSubnetGroupArn: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DBSubnetGroup = {
    import DBSubnetGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DBSubnetGroup
      .builder()
      .optionallyWith(dbSubnetGroupName.map(value => value: java.lang.String))(
        _.dbSubnetGroupName
      )
      .optionallyWith(
        dbSubnetGroupDescription.map(value => value: java.lang.String)
      )(_.dbSubnetGroupDescription)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(subnetGroupStatus.map(value => value: java.lang.String))(
        _.subnetGroupStatus
      )
      .optionallyWith(
        subnets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subnets)
      .optionallyWith(dbSubnetGroupArn.map(value => value: java.lang.String))(
        _.dbSubnetGroupArn
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DBSubnetGroup.ReadOnly =
    zio.aws.rds.model.DBSubnetGroup.wrap(buildAwsValue())
}
object DBSubnetGroup {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.DBSubnetGroup] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DBSubnetGroup =
      zio.aws.rds.model.DBSubnetGroup(
        dbSubnetGroupName.map(value => value),
        dbSubnetGroupDescription.map(value => value),
        vpcId.map(value => value),
        subnetGroupStatus.map(value => value),
        subnets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dbSubnetGroupArn.map(value => value)
      )
    def dbSubnetGroupName: scala.Option[String]
    def dbSubnetGroupDescription: scala.Option[String]
    def vpcId: scala.Option[String]
    def subnetGroupStatus: scala.Option[String]
    def subnets: scala.Option[List[zio.aws.rds.model.Subnet.ReadOnly]]
    def dbSubnetGroupArn: scala.Option[String]
    def getDbSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSubnetGroupName", dbSubnetGroupName)
    def getDbSubnetGroupDescription: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("dbSubnetGroupDescription", dbSubnetGroupDescription)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getSubnetGroupStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetGroupStatus", subnetGroupStatus)
    def getSubnets
        : ZIO[Any, AwsError, List[zio.aws.rds.model.Subnet.ReadOnly]] =
      AwsError.unwrapOptionField("subnets", subnets)
    def getDbSubnetGroupArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSubnetGroupArn", dbSubnetGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DBSubnetGroup
  ) extends zio.aws.rds.model.DBSubnetGroup.ReadOnly {
    override val dbSubnetGroupName: scala.Option[String] =
      scala.Option(impl.dbSubnetGroupName()).map(value => value: String)
    override val dbSubnetGroupDescription: scala.Option[String] =
      scala.Option(impl.dbSubnetGroupDescription()).map(value => value: String)
    override val vpcId: scala.Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
    override val subnetGroupStatus: scala.Option[String] =
      scala.Option(impl.subnetGroupStatus()).map(value => value: String)
    override val subnets
        : scala.Option[List[zio.aws.rds.model.Subnet.ReadOnly]] = scala
      .Option(impl.subnets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.Subnet.wrap(item)
        }.toList
      )
    override val dbSubnetGroupArn: scala.Option[String] =
      scala.Option(impl.dbSubnetGroupArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DBSubnetGroup
  ): zio.aws.rds.model.DBSubnetGroup.ReadOnly = new Wrapper(impl)
}
