package zio.aws.rds.model
import zio.aws.rds.model.primitives.{IntegerOptional, Integer, TStamp}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class DBSnapshot(
    dbSnapshotIdentifier: scala.Option[String] = None,
    dbInstanceIdentifier: scala.Option[String] = None,
    snapshotCreateTime: scala.Option[TStamp] = None,
    engine: scala.Option[String] = None,
    allocatedStorage: scala.Option[Integer] = None,
    status: scala.Option[String] = None,
    port: scala.Option[Integer] = None,
    availabilityZone: scala.Option[String] = None,
    vpcId: scala.Option[String] = None,
    instanceCreateTime: scala.Option[TStamp] = None,
    masterUsername: scala.Option[String] = None,
    engineVersion: scala.Option[String] = None,
    licenseModel: scala.Option[String] = None,
    snapshotType: scala.Option[String] = None,
    iops: scala.Option[IntegerOptional] = None,
    optionGroupName: scala.Option[String] = None,
    percentProgress: scala.Option[Integer] = None,
    sourceRegion: scala.Option[String] = None,
    sourceDBSnapshotIdentifier: scala.Option[String] = None,
    storageType: scala.Option[String] = None,
    tdeCredentialArn: scala.Option[String] = None,
    encrypted: scala.Option[Boolean] = None,
    kmsKeyId: scala.Option[String] = None,
    dbSnapshotArn: scala.Option[String] = None,
    timezone: scala.Option[String] = None,
    iamDatabaseAuthenticationEnabled: scala.Option[Boolean] = None,
    processorFeatures: scala.Option[Iterable[
      zio.aws.rds.model.ProcessorFeature
    ]] = None,
    dbiResourceId: scala.Option[String] = None,
    tagList: scala.Option[Iterable[zio.aws.rds.model.Tag]] = None,
    originalSnapshotCreateTime: scala.Option[TStamp] = None,
    snapshotTarget: scala.Option[String] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.rds.model.DBSnapshot = {
    import DBSnapshot.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DBSnapshot
      .builder()
      .optionallyWith(
        dbSnapshotIdentifier.map(value => value: java.lang.String)
      )(_.dbSnapshotIdentifier)
      .optionallyWith(
        dbInstanceIdentifier.map(value => value: java.lang.String)
      )(_.dbInstanceIdentifier)
      .optionallyWith(
        snapshotCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.snapshotCreateTime)
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(allocatedStorage.map(value => value: java.lang.Integer))(
        _.allocatedStorage
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(port.map(value => value: java.lang.Integer))(_.port)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(
        instanceCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.instanceCreateTime)
      .optionallyWith(masterUsername.map(value => value: java.lang.String))(
        _.masterUsername
      )
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(licenseModel.map(value => value: java.lang.String))(
        _.licenseModel
      )
      .optionallyWith(snapshotType.map(value => value: java.lang.String))(
        _.snapshotType
      )
      .optionallyWith(iops.map(value => value: java.lang.Integer))(_.iops)
      .optionallyWith(optionGroupName.map(value => value: java.lang.String))(
        _.optionGroupName
      )
      .optionallyWith(percentProgress.map(value => value: java.lang.Integer))(
        _.percentProgress
      )
      .optionallyWith(sourceRegion.map(value => value: java.lang.String))(
        _.sourceRegion
      )
      .optionallyWith(
        sourceDBSnapshotIdentifier.map(value => value: java.lang.String)
      )(_.sourceDBSnapshotIdentifier)
      .optionallyWith(storageType.map(value => value: java.lang.String))(
        _.storageType
      )
      .optionallyWith(tdeCredentialArn.map(value => value: java.lang.String))(
        _.tdeCredentialArn
      )
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(dbSnapshotArn.map(value => value: java.lang.String))(
        _.dbSnapshotArn
      )
      .optionallyWith(timezone.map(value => value: java.lang.String))(
        _.timezone
      )
      .optionallyWith(
        iamDatabaseAuthenticationEnabled.map(value => value: java.lang.Boolean)
      )(_.iamDatabaseAuthenticationEnabled)
      .optionallyWith(
        processorFeatures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processorFeatures)
      .optionallyWith(dbiResourceId.map(value => value: java.lang.String))(
        _.dbiResourceId
      )
      .optionallyWith(
        tagList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagList)
      .optionallyWith(
        originalSnapshotCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.originalSnapshotCreateTime)
      .optionallyWith(snapshotTarget.map(value => value: java.lang.String))(
        _.snapshotTarget
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DBSnapshot.ReadOnly =
    zio.aws.rds.model.DBSnapshot.wrap(buildAwsValue())
}
object DBSnapshot {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.DBSnapshot] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DBSnapshot = zio.aws.rds.model.DBSnapshot(
      dbSnapshotIdentifier.map(value => value),
      dbInstanceIdentifier.map(value => value),
      snapshotCreateTime.map(value => value),
      engine.map(value => value),
      allocatedStorage.map(value => value),
      status.map(value => value),
      port.map(value => value),
      availabilityZone.map(value => value),
      vpcId.map(value => value),
      instanceCreateTime.map(value => value),
      masterUsername.map(value => value),
      engineVersion.map(value => value),
      licenseModel.map(value => value),
      snapshotType.map(value => value),
      iops.map(value => value),
      optionGroupName.map(value => value),
      percentProgress.map(value => value),
      sourceRegion.map(value => value),
      sourceDBSnapshotIdentifier.map(value => value),
      storageType.map(value => value),
      tdeCredentialArn.map(value => value),
      encrypted.map(value => value),
      kmsKeyId.map(value => value),
      dbSnapshotArn.map(value => value),
      timezone.map(value => value),
      iamDatabaseAuthenticationEnabled.map(value => value),
      processorFeatures.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      dbiResourceId.map(value => value),
      tagList.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      originalSnapshotCreateTime.map(value => value),
      snapshotTarget.map(value => value)
    )
    def dbSnapshotIdentifier: scala.Option[String]
    def dbInstanceIdentifier: scala.Option[String]
    def snapshotCreateTime: scala.Option[TStamp]
    def engine: scala.Option[String]
    def allocatedStorage: scala.Option[Integer]
    def status: scala.Option[String]
    def port: scala.Option[Integer]
    def availabilityZone: scala.Option[String]
    def vpcId: scala.Option[String]
    def instanceCreateTime: scala.Option[TStamp]
    def masterUsername: scala.Option[String]
    def engineVersion: scala.Option[String]
    def licenseModel: scala.Option[String]
    def snapshotType: scala.Option[String]
    def iops: scala.Option[IntegerOptional]
    def optionGroupName: scala.Option[String]
    def percentProgress: scala.Option[Integer]
    def sourceRegion: scala.Option[String]
    def sourceDBSnapshotIdentifier: scala.Option[String]
    def storageType: scala.Option[String]
    def tdeCredentialArn: scala.Option[String]
    def encrypted: scala.Option[Boolean]
    def kmsKeyId: scala.Option[String]
    def dbSnapshotArn: scala.Option[String]
    def timezone: scala.Option[String]
    def iamDatabaseAuthenticationEnabled: scala.Option[Boolean]
    def processorFeatures
        : scala.Option[List[zio.aws.rds.model.ProcessorFeature.ReadOnly]]
    def dbiResourceId: scala.Option[String]
    def tagList: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]]
    def originalSnapshotCreateTime: scala.Option[TStamp]
    def snapshotTarget: scala.Option[String]
    def getDbSnapshotIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSnapshotIdentifier", dbSnapshotIdentifier)
    def getDbInstanceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceIdentifier", dbInstanceIdentifier)
    def getSnapshotCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("snapshotCreateTime", snapshotCreateTime)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getAllocatedStorage: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("port", port)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getInstanceCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("instanceCreateTime", instanceCreateTime)
    def getMasterUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUsername", masterUsername)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getLicenseModel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("licenseModel", licenseModel)
    def getSnapshotType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotType", snapshotType)
    def getIops: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("iops", iops)
    def getOptionGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optionGroupName", optionGroupName)
    def getPercentProgress: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("percentProgress", percentProgress)
    def getSourceRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceRegion", sourceRegion)
    def getSourceDBSnapshotIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "sourceDBSnapshotIdentifier",
        sourceDBSnapshotIdentifier
      )
    def getStorageType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getTdeCredentialArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tdeCredentialArn", tdeCredentialArn)
    def getEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getDbSnapshotArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSnapshotArn", dbSnapshotArn)
    def getTimezone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("timezone", timezone)
    def getIamDatabaseAuthenticationEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "iamDatabaseAuthenticationEnabled",
        iamDatabaseAuthenticationEnabled
      )
    def getProcessorFeatures: ZIO[Any, AwsError, List[
      zio.aws.rds.model.ProcessorFeature.ReadOnly
    ]] = AwsError.unwrapOptionField("processorFeatures", processorFeatures)
    def getDbiResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbiResourceId", dbiResourceId)
    def getTagList: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tagList", tagList)
    def getOriginalSnapshotCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField(
        "originalSnapshotCreateTime",
        originalSnapshotCreateTime
      )
    def getSnapshotTarget: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotTarget", snapshotTarget)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DBSnapshot
  ) extends zio.aws.rds.model.DBSnapshot.ReadOnly {
    override val dbSnapshotIdentifier: scala.Option[String] =
      scala.Option(impl.dbSnapshotIdentifier()).map(value => value: String)
    override val dbInstanceIdentifier: scala.Option[String] =
      scala.Option(impl.dbInstanceIdentifier()).map(value => value: String)
    override val snapshotCreateTime: scala.Option[TStamp] = scala
      .Option(impl.snapshotCreateTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val engine: scala.Option[String] =
      scala.Option(impl.engine()).map(value => value: String)
    override val allocatedStorage: scala.Option[Integer] =
      scala.Option(impl.allocatedStorage()).map(value => value: Integer)
    override val status: scala.Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val port: scala.Option[Integer] =
      scala.Option(impl.port()).map(value => value: Integer)
    override val availabilityZone: scala.Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val vpcId: scala.Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
    override val instanceCreateTime: scala.Option[TStamp] = scala
      .Option(impl.instanceCreateTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val masterUsername: scala.Option[String] =
      scala.Option(impl.masterUsername()).map(value => value: String)
    override val engineVersion: scala.Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val licenseModel: scala.Option[String] =
      scala.Option(impl.licenseModel()).map(value => value: String)
    override val snapshotType: scala.Option[String] =
      scala.Option(impl.snapshotType()).map(value => value: String)
    override val iops: scala.Option[IntegerOptional] =
      scala.Option(impl.iops()).map(value => value: IntegerOptional)
    override val optionGroupName: scala.Option[String] =
      scala.Option(impl.optionGroupName()).map(value => value: String)
    override val percentProgress: scala.Option[Integer] =
      scala.Option(impl.percentProgress()).map(value => value: Integer)
    override val sourceRegion: scala.Option[String] =
      scala.Option(impl.sourceRegion()).map(value => value: String)
    override val sourceDBSnapshotIdentifier: scala.Option[String] = scala
      .Option(impl.sourceDBSnapshotIdentifier())
      .map(value => value: String)
    override val storageType: scala.Option[String] =
      scala.Option(impl.storageType()).map(value => value: String)
    override val tdeCredentialArn: scala.Option[String] =
      scala.Option(impl.tdeCredentialArn()).map(value => value: String)
    override val encrypted: scala.Option[Boolean] =
      scala.Option(impl.encrypted()).map(value => value: Boolean)
    override val kmsKeyId: scala.Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val dbSnapshotArn: scala.Option[String] =
      scala.Option(impl.dbSnapshotArn()).map(value => value: String)
    override val timezone: scala.Option[String] =
      scala.Option(impl.timezone()).map(value => value: String)
    override val iamDatabaseAuthenticationEnabled: scala.Option[Boolean] = scala
      .Option(impl.iamDatabaseAuthenticationEnabled())
      .map(value => value: Boolean)
    override val processorFeatures
        : scala.Option[List[zio.aws.rds.model.ProcessorFeature.ReadOnly]] =
      scala
        .Option(impl.processorFeatures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.ProcessorFeature.wrap(item)
          }.toList
        )
    override val dbiResourceId: scala.Option[String] =
      scala.Option(impl.dbiResourceId()).map(value => value: String)
    override val tagList: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tagList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
    override val originalSnapshotCreateTime: scala.Option[TStamp] = scala
      .Option(impl.originalSnapshotCreateTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val snapshotTarget: scala.Option[String] =
      scala.Option(impl.snapshotTarget()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DBSnapshot
  ): zio.aws.rds.model.DBSnapshot.ReadOnly = new Wrapper(impl)
}
