package zio.aws.rds.model
import scala.jdk.CollectionConverters.*
sealed trait DBProxyEndpointTargetRole {
  def unwrap
      : software.amazon.awssdk.services.rds.model.DBProxyEndpointTargetRole
}
object DBProxyEndpointTargetRole {
  def wrap(
      value: software.amazon.awssdk.services.rds.model.DBProxyEndpointTargetRole
  ): zio.aws.rds.model.DBProxyEndpointTargetRole = value match {
    case software.amazon.awssdk.services.rds.model.DBProxyEndpointTargetRole.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rds.model.DBProxyEndpointTargetRole.READ_WRITE =>
      val r = READ_WRITE
      r
    case software.amazon.awssdk.services.rds.model.DBProxyEndpointTargetRole.READ_ONLY =>
      val r = READ_ONLY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.rds.model.DBProxyEndpointTargetRole {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.DBProxyEndpointTargetRole =
      software.amazon.awssdk.services.rds.model.DBProxyEndpointTargetRole.UNKNOWN_TO_SDK_VERSION
  }
  case object READ_WRITE extends zio.aws.rds.model.DBProxyEndpointTargetRole {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.DBProxyEndpointTargetRole =
      software.amazon.awssdk.services.rds.model.DBProxyEndpointTargetRole.READ_WRITE
  }
  case object READ_ONLY extends zio.aws.rds.model.DBProxyEndpointTargetRole {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.DBProxyEndpointTargetRole =
      software.amazon.awssdk.services.rds.model.DBProxyEndpointTargetRole.READ_ONLY
  }
}
