package zio.aws.rds.model
import zio.aws.rds.model.primitives.{IntegerOptional, TStamp, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class DBInstanceAutomatedBackup(
    dbInstanceArn: scala.Option[String] = None,
    dbiResourceId: scala.Option[String] = None,
    region: scala.Option[String] = None,
    dbInstanceIdentifier: scala.Option[String] = None,
    restoreWindow: scala.Option[zio.aws.rds.model.RestoreWindow] = None,
    allocatedStorage: scala.Option[Integer] = None,
    status: scala.Option[String] = None,
    port: scala.Option[Integer] = None,
    availabilityZone: scala.Option[String] = None,
    vpcId: scala.Option[String] = None,
    instanceCreateTime: scala.Option[TStamp] = None,
    masterUsername: scala.Option[String] = None,
    engine: scala.Option[String] = None,
    engineVersion: scala.Option[String] = None,
    licenseModel: scala.Option[String] = None,
    iops: scala.Option[IntegerOptional] = None,
    optionGroupName: scala.Option[String] = None,
    tdeCredentialArn: scala.Option[String] = None,
    encrypted: scala.Option[Boolean] = None,
    storageType: scala.Option[String] = None,
    kmsKeyId: scala.Option[String] = None,
    timezone: scala.Option[String] = None,
    iamDatabaseAuthenticationEnabled: scala.Option[Boolean] = None,
    backupRetentionPeriod: scala.Option[IntegerOptional] = None,
    dbInstanceAutomatedBackupsArn: scala.Option[String] = None,
    dbInstanceAutomatedBackupsReplications: scala.Option[Iterable[
      zio.aws.rds.model.DBInstanceAutomatedBackupsReplication
    ]] = None,
    backupTarget: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DBInstanceAutomatedBackup = {
    import DBInstanceAutomatedBackup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DBInstanceAutomatedBackup
      .builder()
      .optionallyWith(dbInstanceArn.map(value => value: java.lang.String))(
        _.dbInstanceArn
      )
      .optionallyWith(dbiResourceId.map(value => value: java.lang.String))(
        _.dbiResourceId
      )
      .optionallyWith(region.map(value => value: java.lang.String))(_.region)
      .optionallyWith(
        dbInstanceIdentifier.map(value => value: java.lang.String)
      )(_.dbInstanceIdentifier)
      .optionallyWith(restoreWindow.map(value => value.buildAwsValue()))(
        _.restoreWindow
      )
      .optionallyWith(allocatedStorage.map(value => value: java.lang.Integer))(
        _.allocatedStorage
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(port.map(value => value: java.lang.Integer))(_.port)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(
        instanceCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.instanceCreateTime)
      .optionallyWith(masterUsername.map(value => value: java.lang.String))(
        _.masterUsername
      )
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(licenseModel.map(value => value: java.lang.String))(
        _.licenseModel
      )
      .optionallyWith(iops.map(value => value: java.lang.Integer))(_.iops)
      .optionallyWith(optionGroupName.map(value => value: java.lang.String))(
        _.optionGroupName
      )
      .optionallyWith(tdeCredentialArn.map(value => value: java.lang.String))(
        _.tdeCredentialArn
      )
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(storageType.map(value => value: java.lang.String))(
        _.storageType
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(timezone.map(value => value: java.lang.String))(
        _.timezone
      )
      .optionallyWith(
        iamDatabaseAuthenticationEnabled.map(value => value: java.lang.Boolean)
      )(_.iamDatabaseAuthenticationEnabled)
      .optionallyWith(
        backupRetentionPeriod.map(value => value: java.lang.Integer)
      )(_.backupRetentionPeriod)
      .optionallyWith(
        dbInstanceAutomatedBackupsArn.map(value => value: java.lang.String)
      )(_.dbInstanceAutomatedBackupsArn)
      .optionallyWith(
        dbInstanceAutomatedBackupsReplications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbInstanceAutomatedBackupsReplications)
      .optionallyWith(backupTarget.map(value => value: java.lang.String))(
        _.backupTarget
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DBInstanceAutomatedBackup.ReadOnly =
    zio.aws.rds.model.DBInstanceAutomatedBackup.wrap(buildAwsValue())
}
object DBInstanceAutomatedBackup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DBInstanceAutomatedBackup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DBInstanceAutomatedBackup =
      zio.aws.rds.model.DBInstanceAutomatedBackup(
        dbInstanceArn.map(value => value),
        dbiResourceId.map(value => value),
        region.map(value => value),
        dbInstanceIdentifier.map(value => value),
        restoreWindow.map(value => value.asEditable),
        allocatedStorage.map(value => value),
        status.map(value => value),
        port.map(value => value),
        availabilityZone.map(value => value),
        vpcId.map(value => value),
        instanceCreateTime.map(value => value),
        masterUsername.map(value => value),
        engine.map(value => value),
        engineVersion.map(value => value),
        licenseModel.map(value => value),
        iops.map(value => value),
        optionGroupName.map(value => value),
        tdeCredentialArn.map(value => value),
        encrypted.map(value => value),
        storageType.map(value => value),
        kmsKeyId.map(value => value),
        timezone.map(value => value),
        iamDatabaseAuthenticationEnabled.map(value => value),
        backupRetentionPeriod.map(value => value),
        dbInstanceAutomatedBackupsArn.map(value => value),
        dbInstanceAutomatedBackupsReplications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        backupTarget.map(value => value)
      )
    def dbInstanceArn: scala.Option[String]
    def dbiResourceId: scala.Option[String]
    def region: scala.Option[String]
    def dbInstanceIdentifier: scala.Option[String]
    def restoreWindow: scala.Option[zio.aws.rds.model.RestoreWindow.ReadOnly]
    def allocatedStorage: scala.Option[Integer]
    def status: scala.Option[String]
    def port: scala.Option[Integer]
    def availabilityZone: scala.Option[String]
    def vpcId: scala.Option[String]
    def instanceCreateTime: scala.Option[TStamp]
    def masterUsername: scala.Option[String]
    def engine: scala.Option[String]
    def engineVersion: scala.Option[String]
    def licenseModel: scala.Option[String]
    def iops: scala.Option[IntegerOptional]
    def optionGroupName: scala.Option[String]
    def tdeCredentialArn: scala.Option[String]
    def encrypted: scala.Option[Boolean]
    def storageType: scala.Option[String]
    def kmsKeyId: scala.Option[String]
    def timezone: scala.Option[String]
    def iamDatabaseAuthenticationEnabled: scala.Option[Boolean]
    def backupRetentionPeriod: scala.Option[IntegerOptional]
    def dbInstanceAutomatedBackupsArn: scala.Option[String]
    def dbInstanceAutomatedBackupsReplications: scala.Option[List[
      zio.aws.rds.model.DBInstanceAutomatedBackupsReplication.ReadOnly
    ]]
    def backupTarget: scala.Option[String]
    def getDbInstanceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceArn", dbInstanceArn)
    def getDbiResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbiResourceId", dbiResourceId)
    def getRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("region", region)
    def getDbInstanceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceIdentifier", dbInstanceIdentifier)
    def getRestoreWindow
        : ZIO[Any, AwsError, zio.aws.rds.model.RestoreWindow.ReadOnly] =
      AwsError.unwrapOptionField("restoreWindow", restoreWindow)
    def getAllocatedStorage: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("port", port)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getInstanceCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("instanceCreateTime", instanceCreateTime)
    def getMasterUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUsername", masterUsername)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getLicenseModel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("licenseModel", licenseModel)
    def getIops: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("iops", iops)
    def getOptionGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optionGroupName", optionGroupName)
    def getTdeCredentialArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tdeCredentialArn", tdeCredentialArn)
    def getEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getStorageType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getTimezone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("timezone", timezone)
    def getIamDatabaseAuthenticationEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "iamDatabaseAuthenticationEnabled",
        iamDatabaseAuthenticationEnabled
      )
    def getBackupRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriod)
    def getDbInstanceAutomatedBackupsArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbInstanceAutomatedBackupsArn",
        dbInstanceAutomatedBackupsArn
      )
    def getDbInstanceAutomatedBackupsReplications: ZIO[Any, AwsError, List[
      zio.aws.rds.model.DBInstanceAutomatedBackupsReplication.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "dbInstanceAutomatedBackupsReplications",
      dbInstanceAutomatedBackupsReplications
    )
    def getBackupTarget: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("backupTarget", backupTarget)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DBInstanceAutomatedBackup
  ) extends zio.aws.rds.model.DBInstanceAutomatedBackup.ReadOnly {
    override val dbInstanceArn: scala.Option[String] =
      scala.Option(impl.dbInstanceArn()).map(value => value: String)
    override val dbiResourceId: scala.Option[String] =
      scala.Option(impl.dbiResourceId()).map(value => value: String)
    override val region: scala.Option[String] =
      scala.Option(impl.region()).map(value => value: String)
    override val dbInstanceIdentifier: scala.Option[String] =
      scala.Option(impl.dbInstanceIdentifier()).map(value => value: String)
    override val restoreWindow
        : scala.Option[zio.aws.rds.model.RestoreWindow.ReadOnly] = scala
      .Option(impl.restoreWindow())
      .map(value => zio.aws.rds.model.RestoreWindow.wrap(value))
    override val allocatedStorage: scala.Option[Integer] =
      scala.Option(impl.allocatedStorage()).map(value => value: Integer)
    override val status: scala.Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val port: scala.Option[Integer] =
      scala.Option(impl.port()).map(value => value: Integer)
    override val availabilityZone: scala.Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val vpcId: scala.Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
    override val instanceCreateTime: scala.Option[TStamp] = scala
      .Option(impl.instanceCreateTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val masterUsername: scala.Option[String] =
      scala.Option(impl.masterUsername()).map(value => value: String)
    override val engine: scala.Option[String] =
      scala.Option(impl.engine()).map(value => value: String)
    override val engineVersion: scala.Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val licenseModel: scala.Option[String] =
      scala.Option(impl.licenseModel()).map(value => value: String)
    override val iops: scala.Option[IntegerOptional] =
      scala.Option(impl.iops()).map(value => value: IntegerOptional)
    override val optionGroupName: scala.Option[String] =
      scala.Option(impl.optionGroupName()).map(value => value: String)
    override val tdeCredentialArn: scala.Option[String] =
      scala.Option(impl.tdeCredentialArn()).map(value => value: String)
    override val encrypted: scala.Option[Boolean] =
      scala.Option(impl.encrypted()).map(value => value: Boolean)
    override val storageType: scala.Option[String] =
      scala.Option(impl.storageType()).map(value => value: String)
    override val kmsKeyId: scala.Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val timezone: scala.Option[String] =
      scala.Option(impl.timezone()).map(value => value: String)
    override val iamDatabaseAuthenticationEnabled: scala.Option[Boolean] = scala
      .Option(impl.iamDatabaseAuthenticationEnabled())
      .map(value => value: Boolean)
    override val backupRetentionPeriod: scala.Option[IntegerOptional] = scala
      .Option(impl.backupRetentionPeriod())
      .map(value => value: IntegerOptional)
    override val dbInstanceAutomatedBackupsArn: scala.Option[String] = scala
      .Option(impl.dbInstanceAutomatedBackupsArn())
      .map(value => value: String)
    override val dbInstanceAutomatedBackupsReplications: scala.Option[List[
      zio.aws.rds.model.DBInstanceAutomatedBackupsReplication.ReadOnly
    ]] = scala
      .Option(impl.dbInstanceAutomatedBackupsReplications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.DBInstanceAutomatedBackupsReplication.wrap(item)
        }.toList
      )
    override val backupTarget: scala.Option[String] =
      scala.Option(impl.backupTarget()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DBInstanceAutomatedBackup
  ): zio.aws.rds.model.DBInstanceAutomatedBackup.ReadOnly = new Wrapper(impl)
}
