package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DBClusterRole(
    roleArn: scala.Option[String] = None,
    status: scala.Option[String] = None,
    featureName: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DBClusterRole = {
    import DBClusterRole.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DBClusterRole
      .builder()
      .optionallyWith(roleArn.map(value => value: java.lang.String))(_.roleArn)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(featureName.map(value => value: java.lang.String))(
        _.featureName
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DBClusterRole.ReadOnly =
    zio.aws.rds.model.DBClusterRole.wrap(buildAwsValue())
}
object DBClusterRole {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.DBClusterRole] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DBClusterRole =
      zio.aws.rds.model.DBClusterRole(
        roleArn.map(value => value),
        status.map(value => value),
        featureName.map(value => value)
      )
    def roleArn: scala.Option[String]
    def status: scala.Option[String]
    def featureName: scala.Option[String]
    def getRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getFeatureName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("featureName", featureName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DBClusterRole
  ) extends zio.aws.rds.model.DBClusterRole.ReadOnly {
    override val roleArn: scala.Option[String] =
      scala.Option(impl.roleArn()).map(value => value: String)
    override val status: scala.Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val featureName: scala.Option[String] =
      scala.Option(impl.featureName()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DBClusterRole
  ): zio.aws.rds.model.DBClusterRole.ReadOnly = new Wrapper(impl)
}
