package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DBClusterParameterGroup(
    dbClusterParameterGroupName: scala.Option[String] = None,
    dbParameterGroupFamily: scala.Option[String] = None,
    description: scala.Option[String] = None,
    dbClusterParameterGroupArn: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DBClusterParameterGroup = {
    import DBClusterParameterGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DBClusterParameterGroup
      .builder()
      .optionallyWith(
        dbClusterParameterGroupName.map(value => value: java.lang.String)
      )(_.dbClusterParameterGroupName)
      .optionallyWith(
        dbParameterGroupFamily.map(value => value: java.lang.String)
      )(_.dbParameterGroupFamily)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        dbClusterParameterGroupArn.map(value => value: java.lang.String)
      )(_.dbClusterParameterGroupArn)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DBClusterParameterGroup.ReadOnly =
    zio.aws.rds.model.DBClusterParameterGroup.wrap(buildAwsValue())
}
object DBClusterParameterGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DBClusterParameterGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DBClusterParameterGroup =
      zio.aws.rds.model.DBClusterParameterGroup(
        dbClusterParameterGroupName.map(value => value),
        dbParameterGroupFamily.map(value => value),
        description.map(value => value),
        dbClusterParameterGroupArn.map(value => value)
      )
    def dbClusterParameterGroupName: scala.Option[String]
    def dbParameterGroupFamily: scala.Option[String]
    def description: scala.Option[String]
    def dbClusterParameterGroupArn: scala.Option[String]
    def getDbClusterParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbClusterParameterGroupName",
        dbClusterParameterGroupName
      )
    def getDbParameterGroupFamily: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("dbParameterGroupFamily", dbParameterGroupFamily)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getDbClusterParameterGroupArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbClusterParameterGroupArn",
        dbClusterParameterGroupArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DBClusterParameterGroup
  ) extends zio.aws.rds.model.DBClusterParameterGroup.ReadOnly {
    override val dbClusterParameterGroupName: scala.Option[String] = scala
      .Option(impl.dbClusterParameterGroupName())
      .map(value => value: String)
    override val dbParameterGroupFamily: scala.Option[String] =
      scala.Option(impl.dbParameterGroupFamily()).map(value => value: String)
    override val description: scala.Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val dbClusterParameterGroupArn: scala.Option[String] = scala
      .Option(impl.dbClusterParameterGroupArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DBClusterParameterGroup
  ): zio.aws.rds.model.DBClusterParameterGroup.ReadOnly = new Wrapper(impl)
}
