package zio.aws.rds.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.{
  LongOptional,
  BooleanOptional,
  TStamp,
  IntegerOptional
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DBCluster(
    allocatedStorage: scala.Option[IntegerOptional] = None,
    availabilityZones: scala.Option[Iterable[String]] = None,
    backupRetentionPeriod: scala.Option[IntegerOptional] = None,
    characterSetName: scala.Option[String] = None,
    databaseName: scala.Option[String] = None,
    dbClusterIdentifier: scala.Option[String] = None,
    dbClusterParameterGroup: scala.Option[String] = None,
    dbSubnetGroup: scala.Option[String] = None,
    status: scala.Option[String] = None,
    automaticRestartTime: scala.Option[TStamp] = None,
    percentProgress: scala.Option[String] = None,
    earliestRestorableTime: scala.Option[TStamp] = None,
    endpoint: scala.Option[String] = None,
    readerEndpoint: scala.Option[String] = None,
    customEndpoints: scala.Option[Iterable[String]] = None,
    multiAZ: scala.Option[BooleanOptional] = None,
    engine: scala.Option[String] = None,
    engineVersion: scala.Option[String] = None,
    latestRestorableTime: scala.Option[TStamp] = None,
    port: scala.Option[IntegerOptional] = None,
    masterUsername: scala.Option[String] = None,
    dbClusterOptionGroupMemberships: scala.Option[Iterable[
      zio.aws.rds.model.DBClusterOptionGroupStatus
    ]] = None,
    preferredBackupWindow: scala.Option[String] = None,
    preferredMaintenanceWindow: scala.Option[String] = None,
    replicationSourceIdentifier: scala.Option[String] = None,
    readReplicaIdentifiers: scala.Option[Iterable[String]] = None,
    dbClusterMembers: scala.Option[Iterable[
      zio.aws.rds.model.DBClusterMember
    ]] = None,
    vpcSecurityGroups: scala.Option[Iterable[
      zio.aws.rds.model.VpcSecurityGroupMembership
    ]] = None,
    hostedZoneId: scala.Option[String] = None,
    storageEncrypted: scala.Option[Boolean] = None,
    kmsKeyId: scala.Option[String] = None,
    dbClusterResourceId: scala.Option[String] = None,
    dbClusterArn: scala.Option[String] = None,
    associatedRoles: scala.Option[Iterable[zio.aws.rds.model.DBClusterRole]] =
      None,
    iamDatabaseAuthenticationEnabled: scala.Option[BooleanOptional] = None,
    cloneGroupId: scala.Option[String] = None,
    clusterCreateTime: scala.Option[TStamp] = None,
    earliestBacktrackTime: scala.Option[TStamp] = None,
    backtrackWindow: scala.Option[LongOptional] = None,
    backtrackConsumedChangeRecords: scala.Option[LongOptional] = None,
    enabledCloudwatchLogsExports: scala.Option[Iterable[String]] = None,
    capacity: scala.Option[IntegerOptional] = None,
    engineMode: scala.Option[String] = None,
    scalingConfigurationInfo: scala.Option[
      zio.aws.rds.model.ScalingConfigurationInfo
    ] = None,
    deletionProtection: scala.Option[BooleanOptional] = None,
    httpEndpointEnabled: scala.Option[BooleanOptional] = None,
    activityStreamMode: scala.Option[zio.aws.rds.model.ActivityStreamMode] =
      None,
    activityStreamStatus: scala.Option[zio.aws.rds.model.ActivityStreamStatus] =
      None,
    activityStreamKmsKeyId: scala.Option[String] = None,
    activityStreamKinesisStreamName: scala.Option[String] = None,
    copyTagsToSnapshot: scala.Option[BooleanOptional] = None,
    crossAccountClone: scala.Option[BooleanOptional] = None,
    domainMemberships: scala.Option[Iterable[
      zio.aws.rds.model.DomainMembership
    ]] = None,
    tagList: scala.Option[Iterable[zio.aws.rds.model.Tag]] = None,
    globalWriteForwardingStatus: scala.Option[
      zio.aws.rds.model.WriteForwardingStatus
    ] = None,
    globalWriteForwardingRequested: scala.Option[BooleanOptional] = None,
    pendingModifiedValues: scala.Option[
      zio.aws.rds.model.ClusterPendingModifiedValues
    ] = None,
    dbClusterInstanceClass: scala.Option[String] = None,
    storageType: scala.Option[String] = None,
    iops: scala.Option[IntegerOptional] = None,
    publiclyAccessible: scala.Option[BooleanOptional] = None,
    autoMinorVersionUpgrade: scala.Option[Boolean] = None,
    monitoringInterval: scala.Option[IntegerOptional] = None,
    monitoringRoleArn: scala.Option[String] = None,
    performanceInsightsEnabled: scala.Option[BooleanOptional] = None,
    performanceInsightsKMSKeyId: scala.Option[String] = None,
    performanceInsightsRetentionPeriod: scala.Option[IntegerOptional] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.rds.model.DBCluster = {
    import DBCluster.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DBCluster
      .builder()
      .optionallyWith(allocatedStorage.map(value => value: Integer))(
        _.allocatedStorage
      )
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(backupRetentionPeriod.map(value => value: Integer))(
        _.backupRetentionPeriod
      )
      .optionallyWith(characterSetName.map(value => value: java.lang.String))(
        _.characterSetName
      )
      .optionallyWith(databaseName.map(value => value: java.lang.String))(
        _.databaseName
      )
      .optionallyWith(
        dbClusterIdentifier.map(value => value: java.lang.String)
      )(_.dbClusterIdentifier)
      .optionallyWith(
        dbClusterParameterGroup.map(value => value: java.lang.String)
      )(_.dbClusterParameterGroup)
      .optionallyWith(dbSubnetGroup.map(value => value: java.lang.String))(
        _.dbSubnetGroup
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        automaticRestartTime.map(value => TStamp.unwrap(value): Instant)
      )(_.automaticRestartTime)
      .optionallyWith(percentProgress.map(value => value: java.lang.String))(
        _.percentProgress
      )
      .optionallyWith(
        earliestRestorableTime.map(value => TStamp.unwrap(value): Instant)
      )(_.earliestRestorableTime)
      .optionallyWith(endpoint.map(value => value: java.lang.String))(
        _.endpoint
      )
      .optionallyWith(readerEndpoint.map(value => value: java.lang.String))(
        _.readerEndpoint
      )
      .optionallyWith(
        customEndpoints.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.customEndpoints)
      .optionallyWith(multiAZ.map(value => value: java.lang.Boolean))(_.multiAZ)
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        latestRestorableTime.map(value => TStamp.unwrap(value): Instant)
      )(_.latestRestorableTime)
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(masterUsername.map(value => value: java.lang.String))(
        _.masterUsername
      )
      .optionallyWith(
        dbClusterOptionGroupMemberships.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbClusterOptionGroupMemberships)
      .optionallyWith(
        preferredBackupWindow.map(value => value: java.lang.String)
      )(_.preferredBackupWindow)
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        replicationSourceIdentifier.map(value => value: java.lang.String)
      )(_.replicationSourceIdentifier)
      .optionallyWith(
        readReplicaIdentifiers.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.readReplicaIdentifiers)
      .optionallyWith(
        dbClusterMembers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbClusterMembers)
      .optionallyWith(
        vpcSecurityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcSecurityGroups)
      .optionallyWith(hostedZoneId.map(value => value: java.lang.String))(
        _.hostedZoneId
      )
      .optionallyWith(storageEncrypted.map(value => value: java.lang.Boolean))(
        _.storageEncrypted
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        dbClusterResourceId.map(value => value: java.lang.String)
      )(_.dbClusterResourceId)
      .optionallyWith(dbClusterArn.map(value => value: java.lang.String))(
        _.dbClusterArn
      )
      .optionallyWith(
        associatedRoles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.associatedRoles)
      .optionallyWith(
        iamDatabaseAuthenticationEnabled.map(value => value: java.lang.Boolean)
      )(_.iamDatabaseAuthenticationEnabled)
      .optionallyWith(cloneGroupId.map(value => value: java.lang.String))(
        _.cloneGroupId
      )
      .optionallyWith(
        clusterCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.clusterCreateTime)
      .optionallyWith(
        earliestBacktrackTime.map(value => TStamp.unwrap(value): Instant)
      )(_.earliestBacktrackTime)
      .optionallyWith(backtrackWindow.map(value => value: java.lang.Long))(
        _.backtrackWindow
      )
      .optionallyWith(
        backtrackConsumedChangeRecords.map(value => value: java.lang.Long)
      )(_.backtrackConsumedChangeRecords)
      .optionallyWith(
        enabledCloudwatchLogsExports.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.enabledCloudwatchLogsExports)
      .optionallyWith(capacity.map(value => value: Integer))(_.capacity)
      .optionallyWith(engineMode.map(value => value: java.lang.String))(
        _.engineMode
      )
      .optionallyWith(
        scalingConfigurationInfo.map(value => value.buildAwsValue())
      )(_.scalingConfigurationInfo)
      .optionallyWith(
        deletionProtection.map(value => value: java.lang.Boolean)
      )(_.deletionProtection)
      .optionallyWith(
        httpEndpointEnabled.map(value => value: java.lang.Boolean)
      )(_.httpEndpointEnabled)
      .optionallyWith(activityStreamMode.map(value => value.unwrap))(
        _.activityStreamMode
      )
      .optionallyWith(activityStreamStatus.map(value => value.unwrap))(
        _.activityStreamStatus
      )
      .optionallyWith(
        activityStreamKmsKeyId.map(value => value: java.lang.String)
      )(_.activityStreamKmsKeyId)
      .optionallyWith(
        activityStreamKinesisStreamName.map(value => value: java.lang.String)
      )(_.activityStreamKinesisStreamName)
      .optionallyWith(
        copyTagsToSnapshot.map(value => value: java.lang.Boolean)
      )(_.copyTagsToSnapshot)
      .optionallyWith(crossAccountClone.map(value => value: java.lang.Boolean))(
        _.crossAccountClone
      )
      .optionallyWith(
        domainMemberships.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainMemberships)
      .optionallyWith(
        tagList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagList)
      .optionallyWith(globalWriteForwardingStatus.map(value => value.unwrap))(
        _.globalWriteForwardingStatus
      )
      .optionallyWith(
        globalWriteForwardingRequested.map(value => value: java.lang.Boolean)
      )(_.globalWriteForwardingRequested)
      .optionallyWith(
        pendingModifiedValues.map(value => value.buildAwsValue())
      )(_.pendingModifiedValues)
      .optionallyWith(
        dbClusterInstanceClass.map(value => value: java.lang.String)
      )(_.dbClusterInstanceClass)
      .optionallyWith(storageType.map(value => value: java.lang.String))(
        _.storageType
      )
      .optionallyWith(iops.map(value => value: Integer))(_.iops)
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(
        autoMinorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.autoMinorVersionUpgrade)
      .optionallyWith(monitoringInterval.map(value => value: Integer))(
        _.monitoringInterval
      )
      .optionallyWith(monitoringRoleArn.map(value => value: java.lang.String))(
        _.monitoringRoleArn
      )
      .optionallyWith(
        performanceInsightsEnabled.map(value => value: java.lang.Boolean)
      )(_.performanceInsightsEnabled)
      .optionallyWith(
        performanceInsightsKMSKeyId.map(value => value: java.lang.String)
      )(_.performanceInsightsKMSKeyId)
      .optionallyWith(
        performanceInsightsRetentionPeriod.map(value => value: Integer)
      )(_.performanceInsightsRetentionPeriod)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DBCluster.ReadOnly =
    zio.aws.rds.model.DBCluster.wrap(buildAwsValue())
}
object DBCluster {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.DBCluster] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DBCluster = zio.aws.rds.model.DBCluster(
      allocatedStorage.map(value => value),
      availabilityZones.map(value => value),
      backupRetentionPeriod.map(value => value),
      characterSetName.map(value => value),
      databaseName.map(value => value),
      dbClusterIdentifier.map(value => value),
      dbClusterParameterGroup.map(value => value),
      dbSubnetGroup.map(value => value),
      status.map(value => value),
      automaticRestartTime.map(value => value),
      percentProgress.map(value => value),
      earliestRestorableTime.map(value => value),
      endpoint.map(value => value),
      readerEndpoint.map(value => value),
      customEndpoints.map(value => value),
      multiAZ.map(value => value),
      engine.map(value => value),
      engineVersion.map(value => value),
      latestRestorableTime.map(value => value),
      port.map(value => value),
      masterUsername.map(value => value),
      dbClusterOptionGroupMemberships.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      preferredBackupWindow.map(value => value),
      preferredMaintenanceWindow.map(value => value),
      replicationSourceIdentifier.map(value => value),
      readReplicaIdentifiers.map(value => value),
      dbClusterMembers.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      vpcSecurityGroups.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      hostedZoneId.map(value => value),
      storageEncrypted.map(value => value),
      kmsKeyId.map(value => value),
      dbClusterResourceId.map(value => value),
      dbClusterArn.map(value => value),
      associatedRoles.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      iamDatabaseAuthenticationEnabled.map(value => value),
      cloneGroupId.map(value => value),
      clusterCreateTime.map(value => value),
      earliestBacktrackTime.map(value => value),
      backtrackWindow.map(value => value),
      backtrackConsumedChangeRecords.map(value => value),
      enabledCloudwatchLogsExports.map(value => value),
      capacity.map(value => value),
      engineMode.map(value => value),
      scalingConfigurationInfo.map(value => value.asEditable),
      deletionProtection.map(value => value),
      httpEndpointEnabled.map(value => value),
      activityStreamMode.map(value => value),
      activityStreamStatus.map(value => value),
      activityStreamKmsKeyId.map(value => value),
      activityStreamKinesisStreamName.map(value => value),
      copyTagsToSnapshot.map(value => value),
      crossAccountClone.map(value => value),
      domainMemberships.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      tagList.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      globalWriteForwardingStatus.map(value => value),
      globalWriteForwardingRequested.map(value => value),
      pendingModifiedValues.map(value => value.asEditable),
      dbClusterInstanceClass.map(value => value),
      storageType.map(value => value),
      iops.map(value => value),
      publiclyAccessible.map(value => value),
      autoMinorVersionUpgrade.map(value => value),
      monitoringInterval.map(value => value),
      monitoringRoleArn.map(value => value),
      performanceInsightsEnabled.map(value => value),
      performanceInsightsKMSKeyId.map(value => value),
      performanceInsightsRetentionPeriod.map(value => value)
    )
    def allocatedStorage: scala.Option[IntegerOptional]
    def availabilityZones: scala.Option[List[String]]
    def backupRetentionPeriod: scala.Option[IntegerOptional]
    def characterSetName: scala.Option[String]
    def databaseName: scala.Option[String]
    def dbClusterIdentifier: scala.Option[String]
    def dbClusterParameterGroup: scala.Option[String]
    def dbSubnetGroup: scala.Option[String]
    def status: scala.Option[String]
    def automaticRestartTime: scala.Option[TStamp]
    def percentProgress: scala.Option[String]
    def earliestRestorableTime: scala.Option[TStamp]
    def endpoint: scala.Option[String]
    def readerEndpoint: scala.Option[String]
    def customEndpoints: scala.Option[List[String]]
    def multiAZ: scala.Option[BooleanOptional]
    def engine: scala.Option[String]
    def engineVersion: scala.Option[String]
    def latestRestorableTime: scala.Option[TStamp]
    def port: scala.Option[IntegerOptional]
    def masterUsername: scala.Option[String]
    def dbClusterOptionGroupMemberships: scala.Option[List[
      zio.aws.rds.model.DBClusterOptionGroupStatus.ReadOnly
    ]]
    def preferredBackupWindow: scala.Option[String]
    def preferredMaintenanceWindow: scala.Option[String]
    def replicationSourceIdentifier: scala.Option[String]
    def readReplicaIdentifiers: scala.Option[List[String]]
    def dbClusterMembers
        : scala.Option[List[zio.aws.rds.model.DBClusterMember.ReadOnly]]
    def vpcSecurityGroups: scala.Option[List[
      zio.aws.rds.model.VpcSecurityGroupMembership.ReadOnly
    ]]
    def hostedZoneId: scala.Option[String]
    def storageEncrypted: scala.Option[Boolean]
    def kmsKeyId: scala.Option[String]
    def dbClusterResourceId: scala.Option[String]
    def dbClusterArn: scala.Option[String]
    def associatedRoles
        : scala.Option[List[zio.aws.rds.model.DBClusterRole.ReadOnly]]
    def iamDatabaseAuthenticationEnabled: scala.Option[BooleanOptional]
    def cloneGroupId: scala.Option[String]
    def clusterCreateTime: scala.Option[TStamp]
    def earliestBacktrackTime: scala.Option[TStamp]
    def backtrackWindow: scala.Option[LongOptional]
    def backtrackConsumedChangeRecords: scala.Option[LongOptional]
    def enabledCloudwatchLogsExports: scala.Option[List[String]]
    def capacity: scala.Option[IntegerOptional]
    def engineMode: scala.Option[String]
    def scalingConfigurationInfo
        : scala.Option[zio.aws.rds.model.ScalingConfigurationInfo.ReadOnly]
    def deletionProtection: scala.Option[BooleanOptional]
    def httpEndpointEnabled: scala.Option[BooleanOptional]
    def activityStreamMode: scala.Option[zio.aws.rds.model.ActivityStreamMode]
    def activityStreamStatus
        : scala.Option[zio.aws.rds.model.ActivityStreamStatus]
    def activityStreamKmsKeyId: scala.Option[String]
    def activityStreamKinesisStreamName: scala.Option[String]
    def copyTagsToSnapshot: scala.Option[BooleanOptional]
    def crossAccountClone: scala.Option[BooleanOptional]
    def domainMemberships
        : scala.Option[List[zio.aws.rds.model.DomainMembership.ReadOnly]]
    def tagList: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]]
    def globalWriteForwardingStatus
        : scala.Option[zio.aws.rds.model.WriteForwardingStatus]
    def globalWriteForwardingRequested: scala.Option[BooleanOptional]
    def pendingModifiedValues
        : scala.Option[zio.aws.rds.model.ClusterPendingModifiedValues.ReadOnly]
    def dbClusterInstanceClass: scala.Option[String]
    def storageType: scala.Option[String]
    def iops: scala.Option[IntegerOptional]
    def publiclyAccessible: scala.Option[BooleanOptional]
    def autoMinorVersionUpgrade: scala.Option[Boolean]
    def monitoringInterval: scala.Option[IntegerOptional]
    def monitoringRoleArn: scala.Option[String]
    def performanceInsightsEnabled: scala.Option[BooleanOptional]
    def performanceInsightsKMSKeyId: scala.Option[String]
    def performanceInsightsRetentionPeriod: scala.Option[IntegerOptional]
    def getAllocatedStorage: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getAvailabilityZones: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getBackupRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriod)
    def getCharacterSetName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("characterSetName", characterSetName)
    def getDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getDbClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifier)
    def getDbClusterParameterGroup: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("dbClusterParameterGroup", dbClusterParameterGroup)
    def getDbSubnetGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSubnetGroup", dbSubnetGroup)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getAutomaticRestartTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("automaticRestartTime", automaticRestartTime)
    def getPercentProgress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("percentProgress", percentProgress)
    def getEarliestRestorableTime: ZIO[Any, AwsError, TStamp] = AwsError
      .unwrapOptionField("earliestRestorableTime", earliestRestorableTime)
    def getEndpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getReaderEndpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("readerEndpoint", readerEndpoint)
    def getCustomEndpoints: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("customEndpoints", customEndpoints)
    def getMultiAZ: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("multiAZ", multiAZ)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getLatestRestorableTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("latestRestorableTime", latestRestorableTime)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getMasterUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUsername", masterUsername)
    def getDbClusterOptionGroupMemberships: ZIO[Any, AwsError, List[
      zio.aws.rds.model.DBClusterOptionGroupStatus.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "dbClusterOptionGroupMemberships",
      dbClusterOptionGroupMemberships
    )
    def getPreferredBackupWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindow)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getReplicationSourceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "replicationSourceIdentifier",
        replicationSourceIdentifier
      )
    def getReadReplicaIdentifiers: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("readReplicaIdentifiers", readReplicaIdentifiers)
    def getDbClusterMembers
        : ZIO[Any, AwsError, List[zio.aws.rds.model.DBClusterMember.ReadOnly]] =
      AwsError.unwrapOptionField("dbClusterMembers", dbClusterMembers)
    def getVpcSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.rds.model.VpcSecurityGroupMembership.ReadOnly
    ]] = AwsError.unwrapOptionField("vpcSecurityGroups", vpcSecurityGroups)
    def getHostedZoneId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hostedZoneId", hostedZoneId)
    def getStorageEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("storageEncrypted", storageEncrypted)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getDbClusterResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterResourceId", dbClusterResourceId)
    def getDbClusterArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterArn", dbClusterArn)
    def getAssociatedRoles
        : ZIO[Any, AwsError, List[zio.aws.rds.model.DBClusterRole.ReadOnly]] =
      AwsError.unwrapOptionField("associatedRoles", associatedRoles)
    def getIamDatabaseAuthenticationEnabled
        : ZIO[Any, AwsError, BooleanOptional] = AwsError.unwrapOptionField(
      "iamDatabaseAuthenticationEnabled",
      iamDatabaseAuthenticationEnabled
    )
    def getCloneGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cloneGroupId", cloneGroupId)
    def getClusterCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("clusterCreateTime", clusterCreateTime)
    def getEarliestBacktrackTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("earliestBacktrackTime", earliestBacktrackTime)
    def getBacktrackWindow: ZIO[Any, AwsError, LongOptional] =
      AwsError.unwrapOptionField("backtrackWindow", backtrackWindow)
    def getBacktrackConsumedChangeRecords: ZIO[Any, AwsError, LongOptional] =
      AwsError.unwrapOptionField(
        "backtrackConsumedChangeRecords",
        backtrackConsumedChangeRecords
      )
    def getEnabledCloudwatchLogsExports: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "enabledCloudwatchLogsExports",
        enabledCloudwatchLogsExports
      )
    def getCapacity: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("capacity", capacity)
    def getEngineMode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineMode", engineMode)
    def getScalingConfigurationInfo: ZIO[
      Any,
      AwsError,
      zio.aws.rds.model.ScalingConfigurationInfo.ReadOnly
    ] = AwsError.unwrapOptionField(
      "scalingConfigurationInfo",
      scalingConfigurationInfo
    )
    def getDeletionProtection: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
    def getHttpEndpointEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("httpEndpointEnabled", httpEndpointEnabled)
    def getActivityStreamMode
        : ZIO[Any, AwsError, zio.aws.rds.model.ActivityStreamMode] =
      AwsError.unwrapOptionField("activityStreamMode", activityStreamMode)
    def getActivityStreamStatus
        : ZIO[Any, AwsError, zio.aws.rds.model.ActivityStreamStatus] =
      AwsError.unwrapOptionField("activityStreamStatus", activityStreamStatus)
    def getActivityStreamKmsKeyId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("activityStreamKmsKeyId", activityStreamKmsKeyId)
    def getActivityStreamKinesisStreamName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "activityStreamKinesisStreamName",
        activityStreamKinesisStreamName
      )
    def getCopyTagsToSnapshot: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("copyTagsToSnapshot", copyTagsToSnapshot)
    def getCrossAccountClone: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("crossAccountClone", crossAccountClone)
    def getDomainMemberships: ZIO[Any, AwsError, List[
      zio.aws.rds.model.DomainMembership.ReadOnly
    ]] = AwsError.unwrapOptionField("domainMemberships", domainMemberships)
    def getTagList: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tagList", tagList)
    def getGlobalWriteForwardingStatus
        : ZIO[Any, AwsError, zio.aws.rds.model.WriteForwardingStatus] =
      AwsError.unwrapOptionField(
        "globalWriteForwardingStatus",
        globalWriteForwardingStatus
      )
    def getGlobalWriteForwardingRequested: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "globalWriteForwardingRequested",
        globalWriteForwardingRequested
      )
    def getPendingModifiedValues: ZIO[
      Any,
      AwsError,
      zio.aws.rds.model.ClusterPendingModifiedValues.ReadOnly
    ] =
      AwsError.unwrapOptionField("pendingModifiedValues", pendingModifiedValues)
    def getDbClusterInstanceClass: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("dbClusterInstanceClass", dbClusterInstanceClass)
    def getStorageType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getIops: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("iops", iops)
    def getPubliclyAccessible: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("autoMinorVersionUpgrade", autoMinorVersionUpgrade)
    def getMonitoringInterval: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("monitoringInterval", monitoringInterval)
    def getMonitoringRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("monitoringRoleArn", monitoringRoleArn)
    def getPerformanceInsightsEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "performanceInsightsEnabled",
        performanceInsightsEnabled
      )
    def getPerformanceInsightsKMSKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "performanceInsightsKMSKeyId",
        performanceInsightsKMSKeyId
      )
    def getPerformanceInsightsRetentionPeriod
        : ZIO[Any, AwsError, IntegerOptional] = AwsError.unwrapOptionField(
      "performanceInsightsRetentionPeriod",
      performanceInsightsRetentionPeriod
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DBCluster
  ) extends zio.aws.rds.model.DBCluster.ReadOnly {
    override val allocatedStorage: scala.Option[IntegerOptional] =
      scala.Option(impl.allocatedStorage()).map(value => value: IntegerOptional)
    override val availabilityZones: scala.Option[List[String]] = scala
      .Option(impl.availabilityZones())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val backupRetentionPeriod: scala.Option[IntegerOptional] = scala
      .Option(impl.backupRetentionPeriod())
      .map(value => value: IntegerOptional)
    override val characterSetName: scala.Option[String] =
      scala.Option(impl.characterSetName()).map(value => value: String)
    override val databaseName: scala.Option[String] =
      scala.Option(impl.databaseName()).map(value => value: String)
    override val dbClusterIdentifier: scala.Option[String] =
      scala.Option(impl.dbClusterIdentifier()).map(value => value: String)
    override val dbClusterParameterGroup: scala.Option[String] =
      scala.Option(impl.dbClusterParameterGroup()).map(value => value: String)
    override val dbSubnetGroup: scala.Option[String] =
      scala.Option(impl.dbSubnetGroup()).map(value => value: String)
    override val status: scala.Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val automaticRestartTime: scala.Option[TStamp] = scala
      .Option(impl.automaticRestartTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val percentProgress: scala.Option[String] =
      scala.Option(impl.percentProgress()).map(value => value: String)
    override val earliestRestorableTime: scala.Option[TStamp] = scala
      .Option(impl.earliestRestorableTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val endpoint: scala.Option[String] =
      scala.Option(impl.endpoint()).map(value => value: String)
    override val readerEndpoint: scala.Option[String] =
      scala.Option(impl.readerEndpoint()).map(value => value: String)
    override val customEndpoints: scala.Option[List[String]] = scala
      .Option(impl.customEndpoints())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val multiAZ: scala.Option[BooleanOptional] =
      scala.Option(impl.multiAZ()).map(value => value: BooleanOptional)
    override val engine: scala.Option[String] =
      scala.Option(impl.engine()).map(value => value: String)
    override val engineVersion: scala.Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val latestRestorableTime: scala.Option[TStamp] = scala
      .Option(impl.latestRestorableTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val port: scala.Option[IntegerOptional] =
      scala.Option(impl.port()).map(value => value: IntegerOptional)
    override val masterUsername: scala.Option[String] =
      scala.Option(impl.masterUsername()).map(value => value: String)
    override val dbClusterOptionGroupMemberships: scala.Option[List[
      zio.aws.rds.model.DBClusterOptionGroupStatus.ReadOnly
    ]] = scala
      .Option(impl.dbClusterOptionGroupMemberships())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.DBClusterOptionGroupStatus.wrap(item)
        }.toList
      )
    override val preferredBackupWindow: scala.Option[String] =
      scala.Option(impl.preferredBackupWindow()).map(value => value: String)
    override val preferredMaintenanceWindow: scala.Option[String] = scala
      .Option(impl.preferredMaintenanceWindow())
      .map(value => value: String)
    override val replicationSourceIdentifier: scala.Option[String] = scala
      .Option(impl.replicationSourceIdentifier())
      .map(value => value: String)
    override val readReplicaIdentifiers: scala.Option[List[String]] = scala
      .Option(impl.readReplicaIdentifiers())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val dbClusterMembers
        : scala.Option[List[zio.aws.rds.model.DBClusterMember.ReadOnly]] = scala
      .Option(impl.dbClusterMembers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.DBClusterMember.wrap(item)
        }.toList
      )
    override val vpcSecurityGroups: scala.Option[List[
      zio.aws.rds.model.VpcSecurityGroupMembership.ReadOnly
    ]] = scala
      .Option(impl.vpcSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.VpcSecurityGroupMembership.wrap(item)
        }.toList
      )
    override val hostedZoneId: scala.Option[String] =
      scala.Option(impl.hostedZoneId()).map(value => value: String)
    override val storageEncrypted: scala.Option[Boolean] =
      scala.Option(impl.storageEncrypted()).map(value => value: Boolean)
    override val kmsKeyId: scala.Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val dbClusterResourceId: scala.Option[String] =
      scala.Option(impl.dbClusterResourceId()).map(value => value: String)
    override val dbClusterArn: scala.Option[String] =
      scala.Option(impl.dbClusterArn()).map(value => value: String)
    override val associatedRoles
        : scala.Option[List[zio.aws.rds.model.DBClusterRole.ReadOnly]] = scala
      .Option(impl.associatedRoles())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.DBClusterRole.wrap(item)
        }.toList
      )
    override val iamDatabaseAuthenticationEnabled
        : scala.Option[BooleanOptional] = scala
      .Option(impl.iamDatabaseAuthenticationEnabled())
      .map(value => value: BooleanOptional)
    override val cloneGroupId: scala.Option[String] =
      scala.Option(impl.cloneGroupId()).map(value => value: String)
    override val clusterCreateTime: scala.Option[TStamp] = scala
      .Option(impl.clusterCreateTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val earliestBacktrackTime: scala.Option[TStamp] = scala
      .Option(impl.earliestBacktrackTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val backtrackWindow: scala.Option[LongOptional] =
      scala.Option(impl.backtrackWindow()).map(value => value: LongOptional)
    override val backtrackConsumedChangeRecords: scala.Option[LongOptional] =
      scala
        .Option(impl.backtrackConsumedChangeRecords())
        .map(value => value: LongOptional)
    override val enabledCloudwatchLogsExports: scala.Option[List[String]] =
      scala
        .Option(impl.enabledCloudwatchLogsExports())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val capacity: scala.Option[IntegerOptional] =
      scala.Option(impl.capacity()).map(value => value: IntegerOptional)
    override val engineMode: scala.Option[String] =
      scala.Option(impl.engineMode()).map(value => value: String)
    override val scalingConfigurationInfo
        : scala.Option[zio.aws.rds.model.ScalingConfigurationInfo.ReadOnly] =
      scala
        .Option(impl.scalingConfigurationInfo())
        .map(value => zio.aws.rds.model.ScalingConfigurationInfo.wrap(value))
    override val deletionProtection: scala.Option[BooleanOptional] = scala
      .Option(impl.deletionProtection())
      .map(value => value: BooleanOptional)
    override val httpEndpointEnabled: scala.Option[BooleanOptional] = scala
      .Option(impl.httpEndpointEnabled())
      .map(value => value: BooleanOptional)
    override val activityStreamMode
        : scala.Option[zio.aws.rds.model.ActivityStreamMode] = scala
      .Option(impl.activityStreamMode())
      .map(value => zio.aws.rds.model.ActivityStreamMode.wrap(value))
    override val activityStreamStatus
        : scala.Option[zio.aws.rds.model.ActivityStreamStatus] = scala
      .Option(impl.activityStreamStatus())
      .map(value => zio.aws.rds.model.ActivityStreamStatus.wrap(value))
    override val activityStreamKmsKeyId: scala.Option[String] =
      scala.Option(impl.activityStreamKmsKeyId()).map(value => value: String)
    override val activityStreamKinesisStreamName: scala.Option[String] = scala
      .Option(impl.activityStreamKinesisStreamName())
      .map(value => value: String)
    override val copyTagsToSnapshot: scala.Option[BooleanOptional] = scala
      .Option(impl.copyTagsToSnapshot())
      .map(value => value: BooleanOptional)
    override val crossAccountClone: scala.Option[BooleanOptional] = scala
      .Option(impl.crossAccountClone())
      .map(value => value: BooleanOptional)
    override val domainMemberships
        : scala.Option[List[zio.aws.rds.model.DomainMembership.ReadOnly]] =
      scala
        .Option(impl.domainMemberships())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.DomainMembership.wrap(item)
          }.toList
        )
    override val tagList: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tagList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
    override val globalWriteForwardingStatus
        : scala.Option[zio.aws.rds.model.WriteForwardingStatus] = scala
      .Option(impl.globalWriteForwardingStatus())
      .map(value => zio.aws.rds.model.WriteForwardingStatus.wrap(value))
    override val globalWriteForwardingRequested: scala.Option[BooleanOptional] =
      scala
        .Option(impl.globalWriteForwardingRequested())
        .map(value => value: BooleanOptional)
    override val pendingModifiedValues: scala.Option[
      zio.aws.rds.model.ClusterPendingModifiedValues.ReadOnly
    ] = scala
      .Option(impl.pendingModifiedValues())
      .map(value => zio.aws.rds.model.ClusterPendingModifiedValues.wrap(value))
    override val dbClusterInstanceClass: scala.Option[String] =
      scala.Option(impl.dbClusterInstanceClass()).map(value => value: String)
    override val storageType: scala.Option[String] =
      scala.Option(impl.storageType()).map(value => value: String)
    override val iops: scala.Option[IntegerOptional] =
      scala.Option(impl.iops()).map(value => value: IntegerOptional)
    override val publiclyAccessible: scala.Option[BooleanOptional] = scala
      .Option(impl.publiclyAccessible())
      .map(value => value: BooleanOptional)
    override val autoMinorVersionUpgrade: scala.Option[Boolean] =
      scala.Option(impl.autoMinorVersionUpgrade()).map(value => value: Boolean)
    override val monitoringInterval: scala.Option[IntegerOptional] = scala
      .Option(impl.monitoringInterval())
      .map(value => value: IntegerOptional)
    override val monitoringRoleArn: scala.Option[String] =
      scala.Option(impl.monitoringRoleArn()).map(value => value: String)
    override val performanceInsightsEnabled: scala.Option[BooleanOptional] =
      scala
        .Option(impl.performanceInsightsEnabled())
        .map(value => value: BooleanOptional)
    override val performanceInsightsKMSKeyId: scala.Option[String] = scala
      .Option(impl.performanceInsightsKMSKeyId())
      .map(value => value: String)
    override val performanceInsightsRetentionPeriod
        : scala.Option[IntegerOptional] = scala
      .Option(impl.performanceInsightsRetentionPeriod())
      .map(value => value: IntegerOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DBCluster
  ): zio.aws.rds.model.DBCluster.ReadOnly = new Wrapper(impl)
}
