package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateDbClusterParameterGroupResponse(
    dbClusterParameterGroup: scala.Option[
      zio.aws.rds.model.DBClusterParameterGroup
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CreateDbClusterParameterGroupResponse = {
    import CreateDbClusterParameterGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CreateDbClusterParameterGroupResponse
      .builder()
      .optionallyWith(
        dbClusterParameterGroup.map(value => value.buildAwsValue())
      )(_.dbClusterParameterGroup)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.CreateDbClusterParameterGroupResponse.ReadOnly =
    zio.aws.rds.model.CreateDbClusterParameterGroupResponse
      .wrap(buildAwsValue())
}
object CreateDbClusterParameterGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CreateDbClusterParameterGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CreateDbClusterParameterGroupResponse =
      zio.aws.rds.model.CreateDbClusterParameterGroupResponse(
        dbClusterParameterGroup.map(value => value.asEditable)
      )
    def dbClusterParameterGroup
        : scala.Option[zio.aws.rds.model.DBClusterParameterGroup.ReadOnly]
    def getDbClusterParameterGroup: ZIO[
      Any,
      AwsError,
      zio.aws.rds.model.DBClusterParameterGroup.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dbClusterParameterGroup",
      dbClusterParameterGroup
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CreateDbClusterParameterGroupResponse
  ) extends zio.aws.rds.model.CreateDbClusterParameterGroupResponse.ReadOnly {
    override val dbClusterParameterGroup
        : scala.Option[zio.aws.rds.model.DBClusterParameterGroup.ReadOnly] =
      scala
        .Option(impl.dbClusterParameterGroup())
        .map(value => zio.aws.rds.model.DBClusterParameterGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CreateDbClusterParameterGroupResponse
  ): zio.aws.rds.model.CreateDbClusterParameterGroupResponse.ReadOnly =
    new Wrapper(impl)
}
