package zio.aws.rds.model
import zio.aws.rds.model.primitives.{
  Description,
  BucketName,
  String255,
  CustomEngineVersion,
  CustomEngineName,
  KmsKeyIdOrArn,
  CustomDBEngineVersionManifest
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateCustomDbEngineVersionRequest(
    engine: CustomEngineName,
    engineVersion: CustomEngineVersion,
    databaseInstallationFilesS3BucketName: BucketName,
    databaseInstallationFilesS3Prefix: scala.Option[String255] = None,
    kmsKeyId: KmsKeyIdOrArn,
    description: scala.Option[Description] = None,
    manifest: CustomDBEngineVersionManifest,
    tags: scala.Option[Iterable[zio.aws.rds.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CreateCustomDbEngineVersionRequest = {
    import CreateCustomDbEngineVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CreateCustomDbEngineVersionRequest
      .builder()
      .engine(CustomEngineName.unwrap(engine): java.lang.String)
      .engineVersion(
        CustomEngineVersion.unwrap(engineVersion): java.lang.String
      )
      .databaseInstallationFilesS3BucketName(
        BucketName.unwrap(
          databaseInstallationFilesS3BucketName
        ): java.lang.String
      )
      .optionallyWith(
        databaseInstallationFilesS3Prefix.map(value =>
          String255.unwrap(value): java.lang.String
        )
      )(_.databaseInstallationFilesS3Prefix)
      .kmsKeyId(KmsKeyIdOrArn.unwrap(kmsKeyId): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .manifest(
        CustomDBEngineVersionManifest.unwrap(manifest): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.CreateCustomDbEngineVersionRequest.ReadOnly =
    zio.aws.rds.model.CreateCustomDbEngineVersionRequest.wrap(buildAwsValue())
}
object CreateCustomDbEngineVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CreateCustomDbEngineVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CreateCustomDbEngineVersionRequest =
      zio.aws.rds.model.CreateCustomDbEngineVersionRequest(
        engine,
        engineVersion,
        databaseInstallationFilesS3BucketName,
        databaseInstallationFilesS3Prefix.map(value => value),
        kmsKeyId,
        description.map(value => value),
        manifest,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def engine: CustomEngineName
    def engineVersion: CustomEngineVersion
    def databaseInstallationFilesS3BucketName: BucketName
    def databaseInstallationFilesS3Prefix: scala.Option[String255]
    def kmsKeyId: KmsKeyIdOrArn
    def description: scala.Option[Description]
    def manifest: CustomDBEngineVersionManifest
    def tags: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]]
    def getEngine: ZIO[Any, Nothing, CustomEngineName] = ZIO.succeed(engine)
    def getEngineVersion: ZIO[Any, Nothing, CustomEngineVersion] =
      ZIO.succeed(engineVersion)
    def getDatabaseInstallationFilesS3BucketName
        : ZIO[Any, Nothing, BucketName] =
      ZIO.succeed(databaseInstallationFilesS3BucketName)
    def getDatabaseInstallationFilesS3Prefix: ZIO[Any, AwsError, String255] =
      AwsError.unwrapOptionField(
        "databaseInstallationFilesS3Prefix",
        databaseInstallationFilesS3Prefix
      )
    def getKmsKeyId: ZIO[Any, Nothing, KmsKeyIdOrArn] = ZIO.succeed(kmsKeyId)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getManifest: ZIO[Any, Nothing, CustomDBEngineVersionManifest] =
      ZIO.succeed(manifest)
    def getTags: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CreateCustomDbEngineVersionRequest
  ) extends zio.aws.rds.model.CreateCustomDbEngineVersionRequest.ReadOnly {
    override val engine: CustomEngineName =
      zio.aws.rds.model.primitives.CustomEngineName(impl.engine())
    override val engineVersion: CustomEngineVersion =
      zio.aws.rds.model.primitives.CustomEngineVersion(impl.engineVersion())
    override val databaseInstallationFilesS3BucketName: BucketName =
      zio.aws.rds.model.primitives
        .BucketName(impl.databaseInstallationFilesS3BucketName())
    override val databaseInstallationFilesS3Prefix: scala.Option[String255] =
      scala
        .Option(impl.databaseInstallationFilesS3Prefix())
        .map(value => zio.aws.rds.model.primitives.String255(value))
    override val kmsKeyId: KmsKeyIdOrArn =
      zio.aws.rds.model.primitives.KmsKeyIdOrArn(impl.kmsKeyId())
    override val description: scala.Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.rds.model.primitives.Description(value))
    override val manifest: CustomDBEngineVersionManifest =
      zio.aws.rds.model.primitives
        .CustomDBEngineVersionManifest(impl.manifest())
    override val tags: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CreateCustomDbEngineVersionRequest
  ): zio.aws.rds.model.CreateCustomDbEngineVersionRequest.ReadOnly =
    new Wrapper(impl)
}
