package zio.aws.rds.model
import zio.aws.rds.model.primitives.BooleanOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CopyDbClusterSnapshotRequest(
    sourceDBClusterSnapshotIdentifier: String,
    targetDBClusterSnapshotIdentifier: String,
    kmsKeyId: scala.Option[String] = None,
    preSignedUrl: scala.Option[String] = None,
    copyTags: scala.Option[BooleanOptional] = None,
    tags: scala.Option[Iterable[zio.aws.rds.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CopyDbClusterSnapshotRequest = {
    import CopyDbClusterSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CopyDbClusterSnapshotRequest
      .builder()
      .sourceDBClusterSnapshotIdentifier(
        sourceDBClusterSnapshotIdentifier: java.lang.String
      )
      .targetDBClusterSnapshotIdentifier(
        targetDBClusterSnapshotIdentifier: java.lang.String
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(preSignedUrl.map(value => value: java.lang.String))(
        _.preSignedUrl
      )
      .optionallyWith(copyTags.map(value => value: java.lang.Boolean))(
        _.copyTags
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.CopyDbClusterSnapshotRequest.ReadOnly =
    zio.aws.rds.model.CopyDbClusterSnapshotRequest.wrap(buildAwsValue())
}
object CopyDbClusterSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CopyDbClusterSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CopyDbClusterSnapshotRequest =
      zio.aws.rds.model.CopyDbClusterSnapshotRequest(
        sourceDBClusterSnapshotIdentifier,
        targetDBClusterSnapshotIdentifier,
        kmsKeyId.map(value => value),
        preSignedUrl.map(value => value),
        copyTags.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def sourceDBClusterSnapshotIdentifier: String
    def targetDBClusterSnapshotIdentifier: String
    def kmsKeyId: scala.Option[String]
    def preSignedUrl: scala.Option[String]
    def copyTags: scala.Option[BooleanOptional]
    def tags: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]]
    def getSourceDBClusterSnapshotIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(sourceDBClusterSnapshotIdentifier)
    def getTargetDBClusterSnapshotIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(targetDBClusterSnapshotIdentifier)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getPreSignedUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preSignedUrl", preSignedUrl)
    def getCopyTags: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("copyTags", copyTags)
    def getTags: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CopyDbClusterSnapshotRequest
  ) extends zio.aws.rds.model.CopyDbClusterSnapshotRequest.ReadOnly {
    override val sourceDBClusterSnapshotIdentifier: String =
      impl.sourceDBClusterSnapshotIdentifier(): String
    override val targetDBClusterSnapshotIdentifier: String =
      impl.targetDBClusterSnapshotIdentifier(): String
    override val kmsKeyId: scala.Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val preSignedUrl: scala.Option[String] =
      scala.Option(impl.preSignedUrl()).map(value => value: String)
    override val copyTags: scala.Option[BooleanOptional] =
      scala.Option(impl.copyTags()).map(value => value: BooleanOptional)
    override val tags: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CopyDbClusterSnapshotRequest
  ): zio.aws.rds.model.CopyDbClusterSnapshotRequest.ReadOnly = new Wrapper(impl)
}
