package zio.aws.rds.model
import zio.aws.rds.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ConnectionPoolConfigurationInfo(
    maxConnectionsPercent: scala.Option[Integer] = None,
    maxIdleConnectionsPercent: scala.Option[Integer] = None,
    connectionBorrowTimeout: scala.Option[Integer] = None,
    sessionPinningFilters: scala.Option[Iterable[String]] = None,
    initQuery: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ConnectionPoolConfigurationInfo = {
    import ConnectionPoolConfigurationInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ConnectionPoolConfigurationInfo
      .builder()
      .optionallyWith(
        maxConnectionsPercent.map(value => value: java.lang.Integer)
      )(_.maxConnectionsPercent)
      .optionallyWith(
        maxIdleConnectionsPercent.map(value => value: java.lang.Integer)
      )(_.maxIdleConnectionsPercent)
      .optionallyWith(
        connectionBorrowTimeout.map(value => value: java.lang.Integer)
      )(_.connectionBorrowTimeout)
      .optionallyWith(
        sessionPinningFilters.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.sessionPinningFilters)
      .optionallyWith(initQuery.map(value => value: java.lang.String))(
        _.initQuery
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ConnectionPoolConfigurationInfo.ReadOnly =
    zio.aws.rds.model.ConnectionPoolConfigurationInfo.wrap(buildAwsValue())
}
object ConnectionPoolConfigurationInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ConnectionPoolConfigurationInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ConnectionPoolConfigurationInfo =
      zio.aws.rds.model.ConnectionPoolConfigurationInfo(
        maxConnectionsPercent.map(value => value),
        maxIdleConnectionsPercent.map(value => value),
        connectionBorrowTimeout.map(value => value),
        sessionPinningFilters.map(value => value),
        initQuery.map(value => value)
      )
    def maxConnectionsPercent: scala.Option[Integer]
    def maxIdleConnectionsPercent: scala.Option[Integer]
    def connectionBorrowTimeout: scala.Option[Integer]
    def sessionPinningFilters: scala.Option[List[String]]
    def initQuery: scala.Option[String]
    def getMaxConnectionsPercent: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxConnectionsPercent", maxConnectionsPercent)
    def getMaxIdleConnectionsPercent: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("maxIdleConnectionsPercent", maxIdleConnectionsPercent)
    def getConnectionBorrowTimeout: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("connectionBorrowTimeout", connectionBorrowTimeout)
    def getSessionPinningFilters: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("sessionPinningFilters", sessionPinningFilters)
    def getInitQuery: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("initQuery", initQuery)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ConnectionPoolConfigurationInfo
  ) extends zio.aws.rds.model.ConnectionPoolConfigurationInfo.ReadOnly {
    override val maxConnectionsPercent: scala.Option[Integer] =
      scala.Option(impl.maxConnectionsPercent()).map(value => value: Integer)
    override val maxIdleConnectionsPercent: scala.Option[Integer] = scala
      .Option(impl.maxIdleConnectionsPercent())
      .map(value => value: Integer)
    override val connectionBorrowTimeout: scala.Option[Integer] =
      scala.Option(impl.connectionBorrowTimeout()).map(value => value: Integer)
    override val sessionPinningFilters: scala.Option[List[String]] = scala
      .Option(impl.sessionPinningFilters())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val initQuery: scala.Option[String] =
      scala.Option(impl.initQuery()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ConnectionPoolConfigurationInfo
  ): zio.aws.rds.model.ConnectionPoolConfigurationInfo.ReadOnly = new Wrapper(
    impl
  )
}
