package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RestoreDbInstanceFromDbSnapshotResponse(
    dbInstance: scala.Option[zio.aws.rds.model.DBInstance] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.RestoreDbInstanceFromDbSnapshotResponse = {
    import RestoreDbInstanceFromDbSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.RestoreDbInstanceFromDbSnapshotResponse
      .builder()
      .optionallyWith(dbInstance.map(value => value.buildAwsValue()))(
        _.dbInstance
      )
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.RestoreDbInstanceFromDbSnapshotResponse.ReadOnly =
    zio.aws.rds.model.RestoreDbInstanceFromDbSnapshotResponse
      .wrap(buildAwsValue())
}
object RestoreDbInstanceFromDbSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.RestoreDbInstanceFromDbSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.RestoreDbInstanceFromDbSnapshotResponse =
      zio.aws.rds.model.RestoreDbInstanceFromDbSnapshotResponse(
        dbInstance.map(value => value.asEditable)
      )
    def dbInstance: scala.Option[zio.aws.rds.model.DBInstance.ReadOnly]
    def getDbInstance
        : ZIO[Any, AwsError, zio.aws.rds.model.DBInstance.ReadOnly] =
      AwsError.unwrapOptionField("dbInstance", dbInstance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.RestoreDbInstanceFromDbSnapshotResponse
  ) extends zio.aws.rds.model.RestoreDbInstanceFromDbSnapshotResponse.ReadOnly {
    override val dbInstance
        : scala.Option[zio.aws.rds.model.DBInstance.ReadOnly] = scala
      .Option(impl.dbInstance())
      .map(value => zio.aws.rds.model.DBInstance.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.RestoreDbInstanceFromDbSnapshotResponse
  ): zio.aws.rds.model.RestoreDbInstanceFromDbSnapshotResponse.ReadOnly =
    new Wrapper(impl)
}
