package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RestoreDbClusterToPointInTimeResponse(
    dbCluster: scala.Option[zio.aws.rds.model.DBCluster] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.RestoreDbClusterToPointInTimeResponse = {
    import RestoreDbClusterToPointInTimeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.RestoreDbClusterToPointInTimeResponse
      .builder()
      .optionallyWith(dbCluster.map(value => value.buildAwsValue()))(
        _.dbCluster
      )
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.RestoreDbClusterToPointInTimeResponse.ReadOnly =
    zio.aws.rds.model.RestoreDbClusterToPointInTimeResponse
      .wrap(buildAwsValue())
}
object RestoreDbClusterToPointInTimeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.RestoreDbClusterToPointInTimeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.RestoreDbClusterToPointInTimeResponse =
      zio.aws.rds.model.RestoreDbClusterToPointInTimeResponse(
        dbCluster.map(value => value.asEditable)
      )
    def dbCluster: scala.Option[zio.aws.rds.model.DBCluster.ReadOnly]
    def getDbCluster: ZIO[Any, AwsError, zio.aws.rds.model.DBCluster.ReadOnly] =
      AwsError.unwrapOptionField("dbCluster", dbCluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.RestoreDbClusterToPointInTimeResponse
  ) extends zio.aws.rds.model.RestoreDbClusterToPointInTimeResponse.ReadOnly {
    override val dbCluster: scala.Option[zio.aws.rds.model.DBCluster.ReadOnly] =
      scala
        .Option(impl.dbCluster())
        .map(value => zio.aws.rds.model.DBCluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.RestoreDbClusterToPointInTimeResponse
  ): zio.aws.rds.model.RestoreDbClusterToPointInTimeResponse.ReadOnly =
    new Wrapper(impl)
}
