package zio.aws.rds.model
import scala.jdk.CollectionConverters.*
sealed trait ReplicaMode {
  def unwrap: software.amazon.awssdk.services.rds.model.ReplicaMode
}
object ReplicaMode {
  def wrap(
      value: software.amazon.awssdk.services.rds.model.ReplicaMode
  ): zio.aws.rds.model.ReplicaMode = value match {
    case software.amazon.awssdk.services.rds.model.ReplicaMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rds.model.ReplicaMode.OPEN_READ_ONLY =>
      val r = `open-read-only`
      r
    case software.amazon.awssdk.services.rds.model.ReplicaMode.MOUNTED =>
      val r = mounted
      r
  }
  case object unknownToSdkVersion extends zio.aws.rds.model.ReplicaMode {
    override def unwrap: software.amazon.awssdk.services.rds.model.ReplicaMode =
      software.amazon.awssdk.services.rds.model.ReplicaMode.UNKNOWN_TO_SDK_VERSION
  }
  case object `open-read-only` extends zio.aws.rds.model.ReplicaMode {
    override def unwrap: software.amazon.awssdk.services.rds.model.ReplicaMode =
      software.amazon.awssdk.services.rds.model.ReplicaMode.OPEN_READ_ONLY
  }
  case object mounted extends zio.aws.rds.model.ReplicaMode {
    override def unwrap: software.amazon.awssdk.services.rds.model.ReplicaMode =
      software.amazon.awssdk.services.rds.model.ReplicaMode.MOUNTED
  }
}
