package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RegisterDbProxyTargetsResponse(
    dbProxyTargets: scala.Option[Iterable[zio.aws.rds.model.DBProxyTarget]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.RegisterDbProxyTargetsResponse = {
    import RegisterDbProxyTargetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.RegisterDbProxyTargetsResponse
      .builder()
      .optionallyWith(
        dbProxyTargets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbProxyTargets)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.RegisterDbProxyTargetsResponse.ReadOnly =
    zio.aws.rds.model.RegisterDbProxyTargetsResponse.wrap(buildAwsValue())
}
object RegisterDbProxyTargetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.RegisterDbProxyTargetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.RegisterDbProxyTargetsResponse =
      zio.aws.rds.model.RegisterDbProxyTargetsResponse(
        dbProxyTargets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dbProxyTargets
        : scala.Option[List[zio.aws.rds.model.DBProxyTarget.ReadOnly]]
    def getDbProxyTargets
        : ZIO[Any, AwsError, List[zio.aws.rds.model.DBProxyTarget.ReadOnly]] =
      AwsError.unwrapOptionField("dbProxyTargets", dbProxyTargets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.RegisterDbProxyTargetsResponse
  ) extends zio.aws.rds.model.RegisterDbProxyTargetsResponse.ReadOnly {
    override val dbProxyTargets
        : scala.Option[List[zio.aws.rds.model.DBProxyTarget.ReadOnly]] = scala
      .Option(impl.dbProxyTargets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.DBProxyTarget.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.RegisterDbProxyTargetsResponse
  ): zio.aws.rds.model.RegisterDbProxyTargetsResponse.ReadOnly = new Wrapper(
    impl
  )
}
