package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ModifyDbInstanceResponse(
    dbInstance: scala.Option[zio.aws.rds.model.DBInstance] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ModifyDbInstanceResponse = {
    import ModifyDbInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ModifyDbInstanceResponse
      .builder()
      .optionallyWith(dbInstance.map(value => value.buildAwsValue()))(
        _.dbInstance
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ModifyDbInstanceResponse.ReadOnly =
    zio.aws.rds.model.ModifyDbInstanceResponse.wrap(buildAwsValue())
}
object ModifyDbInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ModifyDbInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ModifyDbInstanceResponse =
      zio.aws.rds.model
        .ModifyDbInstanceResponse(dbInstance.map(value => value.asEditable))
    def dbInstance: scala.Option[zio.aws.rds.model.DBInstance.ReadOnly]
    def getDbInstance
        : ZIO[Any, AwsError, zio.aws.rds.model.DBInstance.ReadOnly] =
      AwsError.unwrapOptionField("dbInstance", dbInstance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ModifyDbInstanceResponse
  ) extends zio.aws.rds.model.ModifyDbInstanceResponse.ReadOnly {
    override val dbInstance
        : scala.Option[zio.aws.rds.model.DBInstance.ReadOnly] = scala
      .Option(impl.dbInstance())
      .map(value => zio.aws.rds.model.DBInstance.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ModifyDbInstanceResponse
  ): zio.aws.rds.model.ModifyDbInstanceResponse.ReadOnly = new Wrapper(impl)
}
