package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class MinimumEngineVersionPerAllowedValue(
    allowedValue: scala.Option[String] = None,
    minimumEngineVersion: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.MinimumEngineVersionPerAllowedValue = {
    import MinimumEngineVersionPerAllowedValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.MinimumEngineVersionPerAllowedValue
      .builder()
      .optionallyWith(allowedValue.map(value => value: java.lang.String))(
        _.allowedValue
      )
      .optionallyWith(
        minimumEngineVersion.map(value => value: java.lang.String)
      )(_.minimumEngineVersion)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.MinimumEngineVersionPerAllowedValue.ReadOnly =
    zio.aws.rds.model.MinimumEngineVersionPerAllowedValue.wrap(buildAwsValue())
}
object MinimumEngineVersionPerAllowedValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.MinimumEngineVersionPerAllowedValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.MinimumEngineVersionPerAllowedValue =
      zio.aws.rds.model.MinimumEngineVersionPerAllowedValue(
        allowedValue.map(value => value),
        minimumEngineVersion.map(value => value)
      )
    def allowedValue: scala.Option[String]
    def minimumEngineVersion: scala.Option[String]
    def getAllowedValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("allowedValue", allowedValue)
    def getMinimumEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("minimumEngineVersion", minimumEngineVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.MinimumEngineVersionPerAllowedValue
  ) extends zio.aws.rds.model.MinimumEngineVersionPerAllowedValue.ReadOnly {
    override val allowedValue: scala.Option[String] =
      scala.Option(impl.allowedValue()).map(value => value: String)
    override val minimumEngineVersion: scala.Option[String] =
      scala.Option(impl.minimumEngineVersion()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.MinimumEngineVersionPerAllowedValue
  ): zio.aws.rds.model.MinimumEngineVersionPerAllowedValue.ReadOnly =
    new Wrapper(impl)
}
