package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(
    resourceName: String,
    filters: scala.Option[Iterable[zio.aws.rds.model.Filter]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ListTagsForResourceRequest
      .builder()
      .resourceName(resourceName: java.lang.String)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.rds.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ListTagsForResourceRequest =
      zio.aws.rds.model.ListTagsForResourceRequest(
        resourceName,
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resourceName: String
    def filters: scala.Option[List[zio.aws.rds.model.Filter.ReadOnly]]
    def getResourceName: ZIO[Any, Nothing, String] = ZIO.succeed(resourceName)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.rds.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ListTagsForResourceRequest
  ) extends zio.aws.rds.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceName: String = impl.resourceName(): String
    override val filters
        : scala.Option[List[zio.aws.rds.model.Filter.ReadOnly]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.Filter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ListTagsForResourceRequest
  ): zio.aws.rds.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(impl)
}
