package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class IPRange(
    status: scala.Option[String] = None,
    cidrip: scala.Option[String] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.rds.model.IPRange = {
    import IPRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.IPRange
      .builder()
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(cidrip.map(value => value: java.lang.String))(_.cidrip)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.IPRange.ReadOnly =
    zio.aws.rds.model.IPRange.wrap(buildAwsValue())
}
object IPRange {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.IPRange] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.IPRange = zio.aws.rds.model
      .IPRange(status.map(value => value), cidrip.map(value => value))
    def status: scala.Option[String]
    def cidrip: scala.Option[String]
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getCidrip: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidrip", cidrip)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.IPRange
  ) extends zio.aws.rds.model.IPRange.ReadOnly {
    override val status: scala.Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val cidrip: scala.Option[String] =
      scala.Option(impl.cidrip()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.IPRange
  ): zio.aws.rds.model.IPRange.ReadOnly = new Wrapper(impl)
}
