package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class FailoverGlobalClusterResponse(
    globalCluster: scala.Option[zio.aws.rds.model.GlobalCluster] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.FailoverGlobalClusterResponse = {
    import FailoverGlobalClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.FailoverGlobalClusterResponse
      .builder()
      .optionallyWith(globalCluster.map(value => value.buildAwsValue()))(
        _.globalCluster
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.FailoverGlobalClusterResponse.ReadOnly =
    zio.aws.rds.model.FailoverGlobalClusterResponse.wrap(buildAwsValue())
}
object FailoverGlobalClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.FailoverGlobalClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.FailoverGlobalClusterResponse =
      zio.aws.rds.model.FailoverGlobalClusterResponse(
        globalCluster.map(value => value.asEditable)
      )
    def globalCluster: scala.Option[zio.aws.rds.model.GlobalCluster.ReadOnly]
    def getGlobalCluster
        : ZIO[Any, AwsError, zio.aws.rds.model.GlobalCluster.ReadOnly] =
      AwsError.unwrapOptionField("globalCluster", globalCluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.FailoverGlobalClusterResponse
  ) extends zio.aws.rds.model.FailoverGlobalClusterResponse.ReadOnly {
    override val globalCluster
        : scala.Option[zio.aws.rds.model.GlobalCluster.ReadOnly] = scala
      .Option(impl.globalCluster())
      .map(value => zio.aws.rds.model.GlobalCluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.FailoverGlobalClusterResponse
  ): zio.aws.rds.model.FailoverGlobalClusterResponse.ReadOnly = new Wrapper(
    impl
  )
}
