package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DomainMembership(
    domain: scala.Option[String] = None,
    status: scala.Option[String] = None,
    fqdn: scala.Option[String] = None,
    iamRoleName: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DomainMembership = {
    import DomainMembership.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DomainMembership
      .builder()
      .optionallyWith(domain.map(value => value: java.lang.String))(_.domain)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(fqdn.map(value => value: java.lang.String))(_.fqdn)
      .optionallyWith(iamRoleName.map(value => value: java.lang.String))(
        _.iamRoleName
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DomainMembership.ReadOnly =
    zio.aws.rds.model.DomainMembership.wrap(buildAwsValue())
}
object DomainMembership {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DomainMembership
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DomainMembership =
      zio.aws.rds.model.DomainMembership(
        domain.map(value => value),
        status.map(value => value),
        fqdn.map(value => value),
        iamRoleName.map(value => value)
      )
    def domain: scala.Option[String]
    def status: scala.Option[String]
    def fqdn: scala.Option[String]
    def iamRoleName: scala.Option[String]
    def getDomain: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domain", domain)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getFqdn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("fqdn", fqdn)
    def getIamRoleName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("iamRoleName", iamRoleName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DomainMembership
  ) extends zio.aws.rds.model.DomainMembership.ReadOnly {
    override val domain: scala.Option[String] =
      scala.Option(impl.domain()).map(value => value: String)
    override val status: scala.Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val fqdn: scala.Option[String] =
      scala.Option(impl.fqdn()).map(value => value: String)
    override val iamRoleName: scala.Option[String] =
      scala.Option(impl.iamRoleName()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DomainMembership
  ): zio.aws.rds.model.DomainMembership.ReadOnly = new Wrapper(impl)
}
