package zio.aws.rds.model
import java.lang.Integer
import zio.aws.rds.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeDbClusterBacktracksRequest(
    dbClusterIdentifier: String,
    backtrackIdentifier: scala.Option[String] = None,
    filters: scala.Option[Iterable[zio.aws.rds.model.Filter]] = None,
    maxRecords: scala.Option[IntegerOptional] = None,
    marker: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksRequest = {
    import DescribeDbClusterBacktracksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksRequest
      .builder()
      .dbClusterIdentifier(dbClusterIdentifier: java.lang.String)
      .optionallyWith(
        backtrackIdentifier.map(value => value: java.lang.String)
      )(_.backtrackIdentifier)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxRecords.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.DescribeDbClusterBacktracksRequest.ReadOnly =
    zio.aws.rds.model.DescribeDbClusterBacktracksRequest.wrap(buildAwsValue())
}
object DescribeDbClusterBacktracksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeDbClusterBacktracksRequest =
      zio.aws.rds.model.DescribeDbClusterBacktracksRequest(
        dbClusterIdentifier,
        backtrackIdentifier.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def dbClusterIdentifier: String
    def backtrackIdentifier: scala.Option[String]
    def filters: scala.Option[List[zio.aws.rds.model.Filter.ReadOnly]]
    def maxRecords: scala.Option[IntegerOptional]
    def marker: scala.Option[String]
    def getDbClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterIdentifier)
    def getBacktrackIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("backtrackIdentifier", backtrackIdentifier)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.rds.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksRequest
  ) extends zio.aws.rds.model.DescribeDbClusterBacktracksRequest.ReadOnly {
    override val dbClusterIdentifier: String =
      impl.dbClusterIdentifier(): String
    override val backtrackIdentifier: scala.Option[String] =
      scala.Option(impl.backtrackIdentifier()).map(value => value: String)
    override val filters
        : scala.Option[List[zio.aws.rds.model.Filter.ReadOnly]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.Filter.wrap(item)
        }.toList
      )
    override val maxRecords: scala.Option[IntegerOptional] = scala
      .Option(impl.maxRecords())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val marker: scala.Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksRequest
  ): zio.aws.rds.model.DescribeDbClusterBacktracksRequest.ReadOnly =
    new Wrapper(impl)
}
