package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteDbSnapshotResponse(
    dbSnapshot: scala.Option[zio.aws.rds.model.DBSnapshot] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DeleteDbSnapshotResponse = {
    import DeleteDbSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DeleteDbSnapshotResponse
      .builder()
      .optionallyWith(dbSnapshot.map(value => value.buildAwsValue()))(
        _.dbSnapshot
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DeleteDbSnapshotResponse.ReadOnly =
    zio.aws.rds.model.DeleteDbSnapshotResponse.wrap(buildAwsValue())
}
object DeleteDbSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DeleteDbSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DeleteDbSnapshotResponse =
      zio.aws.rds.model
        .DeleteDbSnapshotResponse(dbSnapshot.map(value => value.asEditable))
    def dbSnapshot: scala.Option[zio.aws.rds.model.DBSnapshot.ReadOnly]
    def getDbSnapshot
        : ZIO[Any, AwsError, zio.aws.rds.model.DBSnapshot.ReadOnly] =
      AwsError.unwrapOptionField("dbSnapshot", dbSnapshot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DeleteDbSnapshotResponse
  ) extends zio.aws.rds.model.DeleteDbSnapshotResponse.ReadOnly {
    override val dbSnapshot
        : scala.Option[zio.aws.rds.model.DBSnapshot.ReadOnly] = scala
      .Option(impl.dbSnapshot())
      .map(value => zio.aws.rds.model.DBSnapshot.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DeleteDbSnapshotResponse
  ): zio.aws.rds.model.DeleteDbSnapshotResponse.ReadOnly = new Wrapper(impl)
}
