package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteDbProxyRequest(dbProxyName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DeleteDbProxyRequest = {
    import DeleteDbProxyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DeleteDbProxyRequest
      .builder()
      .dbProxyName(dbProxyName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DeleteDbProxyRequest.ReadOnly =
    zio.aws.rds.model.DeleteDbProxyRequest.wrap(buildAwsValue())
}
object DeleteDbProxyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DeleteDbProxyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DeleteDbProxyRequest =
      zio.aws.rds.model.DeleteDbProxyRequest(dbProxyName)
    def dbProxyName: String
    def getDbProxyName: ZIO[Any, Nothing, String] = ZIO.succeed(dbProxyName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DeleteDbProxyRequest
  ) extends zio.aws.rds.model.DeleteDbProxyRequest.ReadOnly {
    override val dbProxyName: String = impl.dbProxyName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DeleteDbProxyRequest
  ): zio.aws.rds.model.DeleteDbProxyRequest.ReadOnly = new Wrapper(impl)
}
