package zio.aws.rds.model
import zio.aws.rds.model.primitives.{
  BooleanOptional,
  IntegerOptional,
  Integer,
  TStamp
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class DBInstance(
    dbInstanceIdentifier: scala.Option[String] = None,
    dbInstanceClass: scala.Option[String] = None,
    engine: scala.Option[String] = None,
    dbInstanceStatus: scala.Option[String] = None,
    automaticRestartTime: scala.Option[TStamp] = None,
    masterUsername: scala.Option[String] = None,
    dbName: scala.Option[String] = None,
    endpoint: scala.Option[zio.aws.rds.model.Endpoint] = None,
    allocatedStorage: scala.Option[Integer] = None,
    instanceCreateTime: scala.Option[TStamp] = None,
    preferredBackupWindow: scala.Option[String] = None,
    backupRetentionPeriod: scala.Option[Integer] = None,
    dbSecurityGroups: scala.Option[Iterable[
      zio.aws.rds.model.DBSecurityGroupMembership
    ]] = None,
    vpcSecurityGroups: scala.Option[Iterable[
      zio.aws.rds.model.VpcSecurityGroupMembership
    ]] = None,
    dbParameterGroups: scala.Option[Iterable[
      zio.aws.rds.model.DBParameterGroupStatus
    ]] = None,
    availabilityZone: scala.Option[String] = None,
    dbSubnetGroup: scala.Option[zio.aws.rds.model.DBSubnetGroup] = None,
    preferredMaintenanceWindow: scala.Option[String] = None,
    pendingModifiedValues: scala.Option[
      zio.aws.rds.model.PendingModifiedValues
    ] = None,
    latestRestorableTime: scala.Option[TStamp] = None,
    multiAZ: scala.Option[Boolean] = None,
    engineVersion: scala.Option[String] = None,
    autoMinorVersionUpgrade: scala.Option[Boolean] = None,
    readReplicaSourceDBInstanceIdentifier: scala.Option[String] = None,
    readReplicaDBInstanceIdentifiers: scala.Option[Iterable[String]] = None,
    readReplicaDBClusterIdentifiers: scala.Option[Iterable[String]] = None,
    replicaMode: scala.Option[zio.aws.rds.model.ReplicaMode] = None,
    licenseModel: scala.Option[String] = None,
    iops: scala.Option[IntegerOptional] = None,
    optionGroupMemberships: scala.Option[Iterable[
      zio.aws.rds.model.OptionGroupMembership
    ]] = None,
    characterSetName: scala.Option[String] = None,
    ncharCharacterSetName: scala.Option[String] = None,
    secondaryAvailabilityZone: scala.Option[String] = None,
    publiclyAccessible: scala.Option[Boolean] = None,
    statusInfos: scala.Option[Iterable[
      zio.aws.rds.model.DBInstanceStatusInfo
    ]] = None,
    storageType: scala.Option[String] = None,
    tdeCredentialArn: scala.Option[String] = None,
    dbInstancePort: scala.Option[Integer] = None,
    dbClusterIdentifier: scala.Option[String] = None,
    storageEncrypted: scala.Option[Boolean] = None,
    kmsKeyId: scala.Option[String] = None,
    dbiResourceId: scala.Option[String] = None,
    caCertificateIdentifier: scala.Option[String] = None,
    domainMemberships: scala.Option[Iterable[
      zio.aws.rds.model.DomainMembership
    ]] = None,
    copyTagsToSnapshot: scala.Option[Boolean] = None,
    monitoringInterval: scala.Option[IntegerOptional] = None,
    enhancedMonitoringResourceArn: scala.Option[String] = None,
    monitoringRoleArn: scala.Option[String] = None,
    promotionTier: scala.Option[IntegerOptional] = None,
    dbInstanceArn: scala.Option[String] = None,
    timezone: scala.Option[String] = None,
    iamDatabaseAuthenticationEnabled: scala.Option[Boolean] = None,
    performanceInsightsEnabled: scala.Option[BooleanOptional] = None,
    performanceInsightsKMSKeyId: scala.Option[String] = None,
    performanceInsightsRetentionPeriod: scala.Option[IntegerOptional] = None,
    enabledCloudwatchLogsExports: scala.Option[Iterable[String]] = None,
    processorFeatures: scala.Option[Iterable[
      zio.aws.rds.model.ProcessorFeature
    ]] = None,
    deletionProtection: scala.Option[Boolean] = None,
    associatedRoles: scala.Option[Iterable[zio.aws.rds.model.DBInstanceRole]] =
      None,
    listenerEndpoint: scala.Option[zio.aws.rds.model.Endpoint] = None,
    maxAllocatedStorage: scala.Option[IntegerOptional] = None,
    tagList: scala.Option[Iterable[zio.aws.rds.model.Tag]] = None,
    dbInstanceAutomatedBackupsReplications: scala.Option[Iterable[
      zio.aws.rds.model.DBInstanceAutomatedBackupsReplication
    ]] = None,
    customerOwnedIpEnabled: scala.Option[BooleanOptional] = None,
    awsBackupRecoveryPointArn: scala.Option[String] = None,
    activityStreamStatus: scala.Option[zio.aws.rds.model.ActivityStreamStatus] =
      None,
    activityStreamKmsKeyId: scala.Option[String] = None,
    activityStreamKinesisStreamName: scala.Option[String] = None,
    activityStreamMode: scala.Option[zio.aws.rds.model.ActivityStreamMode] =
      None,
    activityStreamEngineNativeAuditFieldsIncluded: scala.Option[
      BooleanOptional
    ] = None,
    automationMode: scala.Option[zio.aws.rds.model.AutomationMode] = None,
    resumeFullAutomationModeTime: scala.Option[TStamp] = None,
    customIamInstanceProfile: scala.Option[String] = None,
    backupTarget: scala.Option[String] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.rds.model.DBInstance = {
    import DBInstance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DBInstance
      .builder()
      .optionallyWith(
        dbInstanceIdentifier.map(value => value: java.lang.String)
      )(_.dbInstanceIdentifier)
      .optionallyWith(dbInstanceClass.map(value => value: java.lang.String))(
        _.dbInstanceClass
      )
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(dbInstanceStatus.map(value => value: java.lang.String))(
        _.dbInstanceStatus
      )
      .optionallyWith(
        automaticRestartTime.map(value => TStamp.unwrap(value): Instant)
      )(_.automaticRestartTime)
      .optionallyWith(masterUsername.map(value => value: java.lang.String))(
        _.masterUsername
      )
      .optionallyWith(dbName.map(value => value: java.lang.String))(_.dbName)
      .optionallyWith(endpoint.map(value => value.buildAwsValue()))(_.endpoint)
      .optionallyWith(
        allocatedStorage.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.allocatedStorage)
      .optionallyWith(
        instanceCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.instanceCreateTime)
      .optionallyWith(
        preferredBackupWindow.map(value => value: java.lang.String)
      )(_.preferredBackupWindow)
      .optionallyWith(
        backupRetentionPeriod.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.backupRetentionPeriod)
      .optionallyWith(
        dbSecurityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbSecurityGroups)
      .optionallyWith(
        vpcSecurityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcSecurityGroups)
      .optionallyWith(
        dbParameterGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbParameterGroups)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(dbSubnetGroup.map(value => value.buildAwsValue()))(
        _.dbSubnetGroup
      )
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        pendingModifiedValues.map(value => value.buildAwsValue())
      )(_.pendingModifiedValues)
      .optionallyWith(
        latestRestorableTime.map(value => TStamp.unwrap(value): Instant)
      )(_.latestRestorableTime)
      .optionallyWith(multiAZ.map(value => value: java.lang.Boolean))(_.multiAZ)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        autoMinorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.autoMinorVersionUpgrade)
      .optionallyWith(
        readReplicaSourceDBInstanceIdentifier.map(value =>
          value: java.lang.String
        )
      )(_.readReplicaSourceDBInstanceIdentifier)
      .optionallyWith(
        readReplicaDBInstanceIdentifiers.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.readReplicaDBInstanceIdentifiers)
      .optionallyWith(
        readReplicaDBClusterIdentifiers.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.readReplicaDBClusterIdentifiers)
      .optionallyWith(replicaMode.map(value => value.unwrap))(_.replicaMode)
      .optionallyWith(licenseModel.map(value => value: java.lang.String))(
        _.licenseModel
      )
      .optionallyWith(
        iops.map(value => IntegerOptional.unwrap(value): java.lang.Integer)
      )(_.iops)
      .optionallyWith(
        optionGroupMemberships.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.optionGroupMemberships)
      .optionallyWith(characterSetName.map(value => value: java.lang.String))(
        _.characterSetName
      )
      .optionallyWith(
        ncharCharacterSetName.map(value => value: java.lang.String)
      )(_.ncharCharacterSetName)
      .optionallyWith(
        secondaryAvailabilityZone.map(value => value: java.lang.String)
      )(_.secondaryAvailabilityZone)
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(
        statusInfos.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statusInfos)
      .optionallyWith(storageType.map(value => value: java.lang.String))(
        _.storageType
      )
      .optionallyWith(tdeCredentialArn.map(value => value: java.lang.String))(
        _.tdeCredentialArn
      )
      .optionallyWith(
        dbInstancePort.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.dbInstancePort)
      .optionallyWith(
        dbClusterIdentifier.map(value => value: java.lang.String)
      )(_.dbClusterIdentifier)
      .optionallyWith(storageEncrypted.map(value => value: java.lang.Boolean))(
        _.storageEncrypted
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(dbiResourceId.map(value => value: java.lang.String))(
        _.dbiResourceId
      )
      .optionallyWith(
        caCertificateIdentifier.map(value => value: java.lang.String)
      )(_.caCertificateIdentifier)
      .optionallyWith(
        domainMemberships.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainMemberships)
      .optionallyWith(
        copyTagsToSnapshot.map(value => value: java.lang.Boolean)
      )(_.copyTagsToSnapshot)
      .optionallyWith(
        monitoringInterval.map(value =>
          IntegerOptional.unwrap(value): java.lang.Integer
        )
      )(_.monitoringInterval)
      .optionallyWith(
        enhancedMonitoringResourceArn.map(value => value: java.lang.String)
      )(_.enhancedMonitoringResourceArn)
      .optionallyWith(monitoringRoleArn.map(value => value: java.lang.String))(
        _.monitoringRoleArn
      )
      .optionallyWith(
        promotionTier.map(value =>
          IntegerOptional.unwrap(value): java.lang.Integer
        )
      )(_.promotionTier)
      .optionallyWith(dbInstanceArn.map(value => value: java.lang.String))(
        _.dbInstanceArn
      )
      .optionallyWith(timezone.map(value => value: java.lang.String))(
        _.timezone
      )
      .optionallyWith(
        iamDatabaseAuthenticationEnabled.map(value => value: java.lang.Boolean)
      )(_.iamDatabaseAuthenticationEnabled)
      .optionallyWith(
        performanceInsightsEnabled.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.performanceInsightsEnabled)
      .optionallyWith(
        performanceInsightsKMSKeyId.map(value => value: java.lang.String)
      )(_.performanceInsightsKMSKeyId)
      .optionallyWith(
        performanceInsightsRetentionPeriod.map(value =>
          IntegerOptional.unwrap(value): java.lang.Integer
        )
      )(_.performanceInsightsRetentionPeriod)
      .optionallyWith(
        enabledCloudwatchLogsExports.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.enabledCloudwatchLogsExports)
      .optionallyWith(
        processorFeatures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processorFeatures)
      .optionallyWith(
        deletionProtection.map(value => value: java.lang.Boolean)
      )(_.deletionProtection)
      .optionallyWith(
        associatedRoles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.associatedRoles)
      .optionallyWith(listenerEndpoint.map(value => value.buildAwsValue()))(
        _.listenerEndpoint
      )
      .optionallyWith(
        maxAllocatedStorage.map(value =>
          IntegerOptional.unwrap(value): java.lang.Integer
        )
      )(_.maxAllocatedStorage)
      .optionallyWith(
        tagList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagList)
      .optionallyWith(
        dbInstanceAutomatedBackupsReplications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbInstanceAutomatedBackupsReplications)
      .optionallyWith(
        customerOwnedIpEnabled.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.customerOwnedIpEnabled)
      .optionallyWith(
        awsBackupRecoveryPointArn.map(value => value: java.lang.String)
      )(_.awsBackupRecoveryPointArn)
      .optionallyWith(activityStreamStatus.map(value => value.unwrap))(
        _.activityStreamStatus
      )
      .optionallyWith(
        activityStreamKmsKeyId.map(value => value: java.lang.String)
      )(_.activityStreamKmsKeyId)
      .optionallyWith(
        activityStreamKinesisStreamName.map(value => value: java.lang.String)
      )(_.activityStreamKinesisStreamName)
      .optionallyWith(activityStreamMode.map(value => value.unwrap))(
        _.activityStreamMode
      )
      .optionallyWith(
        activityStreamEngineNativeAuditFieldsIncluded.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.activityStreamEngineNativeAuditFieldsIncluded)
      .optionallyWith(automationMode.map(value => value.unwrap))(
        _.automationMode
      )
      .optionallyWith(
        resumeFullAutomationModeTime.map(value => TStamp.unwrap(value): Instant)
      )(_.resumeFullAutomationModeTime)
      .optionallyWith(
        customIamInstanceProfile.map(value => value: java.lang.String)
      )(_.customIamInstanceProfile)
      .optionallyWith(backupTarget.map(value => value: java.lang.String))(
        _.backupTarget
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DBInstance.ReadOnly =
    zio.aws.rds.model.DBInstance.wrap(buildAwsValue())
}
object DBInstance {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.DBInstance] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DBInstance = zio.aws.rds.model.DBInstance(
      dbInstanceIdentifier.map(value => value),
      dbInstanceClass.map(value => value),
      engine.map(value => value),
      dbInstanceStatus.map(value => value),
      automaticRestartTime.map(value => value),
      masterUsername.map(value => value),
      dbName.map(value => value),
      endpoint.map(value => value.asEditable),
      allocatedStorage.map(value => value),
      instanceCreateTime.map(value => value),
      preferredBackupWindow.map(value => value),
      backupRetentionPeriod.map(value => value),
      dbSecurityGroups.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      vpcSecurityGroups.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      dbParameterGroups.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      availabilityZone.map(value => value),
      dbSubnetGroup.map(value => value.asEditable),
      preferredMaintenanceWindow.map(value => value),
      pendingModifiedValues.map(value => value.asEditable),
      latestRestorableTime.map(value => value),
      multiAZ.map(value => value),
      engineVersion.map(value => value),
      autoMinorVersionUpgrade.map(value => value),
      readReplicaSourceDBInstanceIdentifier.map(value => value),
      readReplicaDBInstanceIdentifiers.map(value => value),
      readReplicaDBClusterIdentifiers.map(value => value),
      replicaMode.map(value => value),
      licenseModel.map(value => value),
      iops.map(value => value),
      optionGroupMemberships.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      characterSetName.map(value => value),
      ncharCharacterSetName.map(value => value),
      secondaryAvailabilityZone.map(value => value),
      publiclyAccessible.map(value => value),
      statusInfos.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      storageType.map(value => value),
      tdeCredentialArn.map(value => value),
      dbInstancePort.map(value => value),
      dbClusterIdentifier.map(value => value),
      storageEncrypted.map(value => value),
      kmsKeyId.map(value => value),
      dbiResourceId.map(value => value),
      caCertificateIdentifier.map(value => value),
      domainMemberships.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      copyTagsToSnapshot.map(value => value),
      monitoringInterval.map(value => value),
      enhancedMonitoringResourceArn.map(value => value),
      monitoringRoleArn.map(value => value),
      promotionTier.map(value => value),
      dbInstanceArn.map(value => value),
      timezone.map(value => value),
      iamDatabaseAuthenticationEnabled.map(value => value),
      performanceInsightsEnabled.map(value => value),
      performanceInsightsKMSKeyId.map(value => value),
      performanceInsightsRetentionPeriod.map(value => value),
      enabledCloudwatchLogsExports.map(value => value),
      processorFeatures.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      deletionProtection.map(value => value),
      associatedRoles.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      listenerEndpoint.map(value => value.asEditable),
      maxAllocatedStorage.map(value => value),
      tagList.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      dbInstanceAutomatedBackupsReplications.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      customerOwnedIpEnabled.map(value => value),
      awsBackupRecoveryPointArn.map(value => value),
      activityStreamStatus.map(value => value),
      activityStreamKmsKeyId.map(value => value),
      activityStreamKinesisStreamName.map(value => value),
      activityStreamMode.map(value => value),
      activityStreamEngineNativeAuditFieldsIncluded.map(value => value),
      automationMode.map(value => value),
      resumeFullAutomationModeTime.map(value => value),
      customIamInstanceProfile.map(value => value),
      backupTarget.map(value => value)
    )
    def dbInstanceIdentifier: scala.Option[String]
    def dbInstanceClass: scala.Option[String]
    def engine: scala.Option[String]
    def dbInstanceStatus: scala.Option[String]
    def automaticRestartTime: scala.Option[TStamp]
    def masterUsername: scala.Option[String]
    def dbName: scala.Option[String]
    def endpoint: scala.Option[zio.aws.rds.model.Endpoint.ReadOnly]
    def allocatedStorage: scala.Option[Integer]
    def instanceCreateTime: scala.Option[TStamp]
    def preferredBackupWindow: scala.Option[String]
    def backupRetentionPeriod: scala.Option[Integer]
    def dbSecurityGroups: scala.Option[List[
      zio.aws.rds.model.DBSecurityGroupMembership.ReadOnly
    ]]
    def vpcSecurityGroups: scala.Option[List[
      zio.aws.rds.model.VpcSecurityGroupMembership.ReadOnly
    ]]
    def dbParameterGroups
        : scala.Option[List[zio.aws.rds.model.DBParameterGroupStatus.ReadOnly]]
    def availabilityZone: scala.Option[String]
    def dbSubnetGroup: scala.Option[zio.aws.rds.model.DBSubnetGroup.ReadOnly]
    def preferredMaintenanceWindow: scala.Option[String]
    def pendingModifiedValues
        : scala.Option[zio.aws.rds.model.PendingModifiedValues.ReadOnly]
    def latestRestorableTime: scala.Option[TStamp]
    def multiAZ: scala.Option[Boolean]
    def engineVersion: scala.Option[String]
    def autoMinorVersionUpgrade: scala.Option[Boolean]
    def readReplicaSourceDBInstanceIdentifier: scala.Option[String]
    def readReplicaDBInstanceIdentifiers: scala.Option[List[String]]
    def readReplicaDBClusterIdentifiers: scala.Option[List[String]]
    def replicaMode: scala.Option[zio.aws.rds.model.ReplicaMode]
    def licenseModel: scala.Option[String]
    def iops: scala.Option[IntegerOptional]
    def optionGroupMemberships
        : scala.Option[List[zio.aws.rds.model.OptionGroupMembership.ReadOnly]]
    def characterSetName: scala.Option[String]
    def ncharCharacterSetName: scala.Option[String]
    def secondaryAvailabilityZone: scala.Option[String]
    def publiclyAccessible: scala.Option[Boolean]
    def statusInfos
        : scala.Option[List[zio.aws.rds.model.DBInstanceStatusInfo.ReadOnly]]
    def storageType: scala.Option[String]
    def tdeCredentialArn: scala.Option[String]
    def dbInstancePort: scala.Option[Integer]
    def dbClusterIdentifier: scala.Option[String]
    def storageEncrypted: scala.Option[Boolean]
    def kmsKeyId: scala.Option[String]
    def dbiResourceId: scala.Option[String]
    def caCertificateIdentifier: scala.Option[String]
    def domainMemberships
        : scala.Option[List[zio.aws.rds.model.DomainMembership.ReadOnly]]
    def copyTagsToSnapshot: scala.Option[Boolean]
    def monitoringInterval: scala.Option[IntegerOptional]
    def enhancedMonitoringResourceArn: scala.Option[String]
    def monitoringRoleArn: scala.Option[String]
    def promotionTier: scala.Option[IntegerOptional]
    def dbInstanceArn: scala.Option[String]
    def timezone: scala.Option[String]
    def iamDatabaseAuthenticationEnabled: scala.Option[Boolean]
    def performanceInsightsEnabled: scala.Option[BooleanOptional]
    def performanceInsightsKMSKeyId: scala.Option[String]
    def performanceInsightsRetentionPeriod: scala.Option[IntegerOptional]
    def enabledCloudwatchLogsExports: scala.Option[List[String]]
    def processorFeatures
        : scala.Option[List[zio.aws.rds.model.ProcessorFeature.ReadOnly]]
    def deletionProtection: scala.Option[Boolean]
    def associatedRoles
        : scala.Option[List[zio.aws.rds.model.DBInstanceRole.ReadOnly]]
    def listenerEndpoint: scala.Option[zio.aws.rds.model.Endpoint.ReadOnly]
    def maxAllocatedStorage: scala.Option[IntegerOptional]
    def tagList: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]]
    def dbInstanceAutomatedBackupsReplications: scala.Option[List[
      zio.aws.rds.model.DBInstanceAutomatedBackupsReplication.ReadOnly
    ]]
    def customerOwnedIpEnabled: scala.Option[BooleanOptional]
    def awsBackupRecoveryPointArn: scala.Option[String]
    def activityStreamStatus
        : scala.Option[zio.aws.rds.model.ActivityStreamStatus]
    def activityStreamKmsKeyId: scala.Option[String]
    def activityStreamKinesisStreamName: scala.Option[String]
    def activityStreamMode: scala.Option[zio.aws.rds.model.ActivityStreamMode]
    def activityStreamEngineNativeAuditFieldsIncluded
        : scala.Option[BooleanOptional]
    def automationMode: scala.Option[zio.aws.rds.model.AutomationMode]
    def resumeFullAutomationModeTime: scala.Option[TStamp]
    def customIamInstanceProfile: scala.Option[String]
    def backupTarget: scala.Option[String]
    def getDbInstanceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceIdentifier", dbInstanceIdentifier)
    def getDbInstanceClass: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceClass", dbInstanceClass)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getDbInstanceStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceStatus", dbInstanceStatus)
    def getAutomaticRestartTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("automaticRestartTime", automaticRestartTime)
    def getMasterUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUsername", masterUsername)
    def getDbName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbName", dbName)
    def getEndpoint: ZIO[Any, AwsError, zio.aws.rds.model.Endpoint.ReadOnly] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getAllocatedStorage: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getInstanceCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("instanceCreateTime", instanceCreateTime)
    def getPreferredBackupWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindow)
    def getBackupRetentionPeriod: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriod)
    def getDbSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.rds.model.DBSecurityGroupMembership.ReadOnly
    ]] = AwsError.unwrapOptionField("dbSecurityGroups", dbSecurityGroups)
    def getVpcSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.rds.model.VpcSecurityGroupMembership.ReadOnly
    ]] = AwsError.unwrapOptionField("vpcSecurityGroups", vpcSecurityGroups)
    def getDbParameterGroups: ZIO[Any, AwsError, List[
      zio.aws.rds.model.DBParameterGroupStatus.ReadOnly
    ]] = AwsError.unwrapOptionField("dbParameterGroups", dbParameterGroups)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getDbSubnetGroup
        : ZIO[Any, AwsError, zio.aws.rds.model.DBSubnetGroup.ReadOnly] =
      AwsError.unwrapOptionField("dbSubnetGroup", dbSubnetGroup)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getPendingModifiedValues
        : ZIO[Any, AwsError, zio.aws.rds.model.PendingModifiedValues.ReadOnly] =
      AwsError.unwrapOptionField("pendingModifiedValues", pendingModifiedValues)
    def getLatestRestorableTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("latestRestorableTime", latestRestorableTime)
    def getMultiAZ: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("multiAZ", multiAZ)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("autoMinorVersionUpgrade", autoMinorVersionUpgrade)
    def getReadReplicaSourceDBInstanceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "readReplicaSourceDBInstanceIdentifier",
        readReplicaSourceDBInstanceIdentifier
      )
    def getReadReplicaDBInstanceIdentifiers: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "readReplicaDBInstanceIdentifiers",
        readReplicaDBInstanceIdentifiers
      )
    def getReadReplicaDBClusterIdentifiers: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "readReplicaDBClusterIdentifiers",
        readReplicaDBClusterIdentifiers
      )
    def getReplicaMode: ZIO[Any, AwsError, zio.aws.rds.model.ReplicaMode] =
      AwsError.unwrapOptionField("replicaMode", replicaMode)
    def getLicenseModel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("licenseModel", licenseModel)
    def getIops: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("iops", iops)
    def getOptionGroupMemberships: ZIO[Any, AwsError, List[
      zio.aws.rds.model.OptionGroupMembership.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "optionGroupMemberships",
      optionGroupMemberships
    )
    def getCharacterSetName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("characterSetName", characterSetName)
    def getNcharCharacterSetName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ncharCharacterSetName", ncharCharacterSetName)
    def getSecondaryAvailabilityZone: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("secondaryAvailabilityZone", secondaryAvailabilityZone)
    def getPubliclyAccessible: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getStatusInfos: ZIO[Any, AwsError, List[
      zio.aws.rds.model.DBInstanceStatusInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("statusInfos", statusInfos)
    def getStorageType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getTdeCredentialArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tdeCredentialArn", tdeCredentialArn)
    def getDbInstancePort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("dbInstancePort", dbInstancePort)
    def getDbClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifier)
    def getStorageEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("storageEncrypted", storageEncrypted)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getDbiResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbiResourceId", dbiResourceId)
    def getCaCertificateIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("caCertificateIdentifier", caCertificateIdentifier)
    def getDomainMemberships: ZIO[Any, AwsError, List[
      zio.aws.rds.model.DomainMembership.ReadOnly
    ]] = AwsError.unwrapOptionField("domainMemberships", domainMemberships)
    def getCopyTagsToSnapshot: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("copyTagsToSnapshot", copyTagsToSnapshot)
    def getMonitoringInterval: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("monitoringInterval", monitoringInterval)
    def getEnhancedMonitoringResourceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "enhancedMonitoringResourceArn",
        enhancedMonitoringResourceArn
      )
    def getMonitoringRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("monitoringRoleArn", monitoringRoleArn)
    def getPromotionTier: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("promotionTier", promotionTier)
    def getDbInstanceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceArn", dbInstanceArn)
    def getTimezone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("timezone", timezone)
    def getIamDatabaseAuthenticationEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "iamDatabaseAuthenticationEnabled",
        iamDatabaseAuthenticationEnabled
      )
    def getPerformanceInsightsEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "performanceInsightsEnabled",
        performanceInsightsEnabled
      )
    def getPerformanceInsightsKMSKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "performanceInsightsKMSKeyId",
        performanceInsightsKMSKeyId
      )
    def getPerformanceInsightsRetentionPeriod
        : ZIO[Any, AwsError, IntegerOptional] = AwsError.unwrapOptionField(
      "performanceInsightsRetentionPeriod",
      performanceInsightsRetentionPeriod
    )
    def getEnabledCloudwatchLogsExports: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "enabledCloudwatchLogsExports",
        enabledCloudwatchLogsExports
      )
    def getProcessorFeatures: ZIO[Any, AwsError, List[
      zio.aws.rds.model.ProcessorFeature.ReadOnly
    ]] = AwsError.unwrapOptionField("processorFeatures", processorFeatures)
    def getDeletionProtection: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
    def getAssociatedRoles
        : ZIO[Any, AwsError, List[zio.aws.rds.model.DBInstanceRole.ReadOnly]] =
      AwsError.unwrapOptionField("associatedRoles", associatedRoles)
    def getListenerEndpoint
        : ZIO[Any, AwsError, zio.aws.rds.model.Endpoint.ReadOnly] =
      AwsError.unwrapOptionField("listenerEndpoint", listenerEndpoint)
    def getMaxAllocatedStorage: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxAllocatedStorage", maxAllocatedStorage)
    def getTagList: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tagList", tagList)
    def getDbInstanceAutomatedBackupsReplications: ZIO[Any, AwsError, List[
      zio.aws.rds.model.DBInstanceAutomatedBackupsReplication.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "dbInstanceAutomatedBackupsReplications",
      dbInstanceAutomatedBackupsReplications
    )
    def getCustomerOwnedIpEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "customerOwnedIpEnabled",
        customerOwnedIpEnabled
      )
    def getAwsBackupRecoveryPointArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("awsBackupRecoveryPointArn", awsBackupRecoveryPointArn)
    def getActivityStreamStatus
        : ZIO[Any, AwsError, zio.aws.rds.model.ActivityStreamStatus] =
      AwsError.unwrapOptionField("activityStreamStatus", activityStreamStatus)
    def getActivityStreamKmsKeyId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("activityStreamKmsKeyId", activityStreamKmsKeyId)
    def getActivityStreamKinesisStreamName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "activityStreamKinesisStreamName",
        activityStreamKinesisStreamName
      )
    def getActivityStreamMode
        : ZIO[Any, AwsError, zio.aws.rds.model.ActivityStreamMode] =
      AwsError.unwrapOptionField("activityStreamMode", activityStreamMode)
    def getActivityStreamEngineNativeAuditFieldsIncluded
        : ZIO[Any, AwsError, BooleanOptional] = AwsError.unwrapOptionField(
      "activityStreamEngineNativeAuditFieldsIncluded",
      activityStreamEngineNativeAuditFieldsIncluded
    )
    def getAutomationMode
        : ZIO[Any, AwsError, zio.aws.rds.model.AutomationMode] =
      AwsError.unwrapOptionField("automationMode", automationMode)
    def getResumeFullAutomationModeTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField(
        "resumeFullAutomationModeTime",
        resumeFullAutomationModeTime
      )
    def getCustomIamInstanceProfile: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("customIamInstanceProfile", customIamInstanceProfile)
    def getBackupTarget: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("backupTarget", backupTarget)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DBInstance
  ) extends zio.aws.rds.model.DBInstance.ReadOnly {
    override val dbInstanceIdentifier: scala.Option[String] =
      scala.Option(impl.dbInstanceIdentifier()).map(value => value: String)
    override val dbInstanceClass: scala.Option[String] =
      scala.Option(impl.dbInstanceClass()).map(value => value: String)
    override val engine: scala.Option[String] =
      scala.Option(impl.engine()).map(value => value: String)
    override val dbInstanceStatus: scala.Option[String] =
      scala.Option(impl.dbInstanceStatus()).map(value => value: String)
    override val automaticRestartTime: scala.Option[TStamp] = scala
      .Option(impl.automaticRestartTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val masterUsername: scala.Option[String] =
      scala.Option(impl.masterUsername()).map(value => value: String)
    override val dbName: scala.Option[String] =
      scala.Option(impl.dbName()).map(value => value: String)
    override val endpoint: scala.Option[zio.aws.rds.model.Endpoint.ReadOnly] =
      scala
        .Option(impl.endpoint())
        .map(value => zio.aws.rds.model.Endpoint.wrap(value))
    override val allocatedStorage: scala.Option[Integer] = scala
      .Option(impl.allocatedStorage())
      .map(value => zio.aws.rds.model.primitives.Integer(value))
    override val instanceCreateTime: scala.Option[TStamp] = scala
      .Option(impl.instanceCreateTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val preferredBackupWindow: scala.Option[String] =
      scala.Option(impl.preferredBackupWindow()).map(value => value: String)
    override val backupRetentionPeriod: scala.Option[Integer] = scala
      .Option(impl.backupRetentionPeriod())
      .map(value => zio.aws.rds.model.primitives.Integer(value))
    override val dbSecurityGroups: scala.Option[List[
      zio.aws.rds.model.DBSecurityGroupMembership.ReadOnly
    ]] = scala
      .Option(impl.dbSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.DBSecurityGroupMembership.wrap(item)
        }.toList
      )
    override val vpcSecurityGroups: scala.Option[List[
      zio.aws.rds.model.VpcSecurityGroupMembership.ReadOnly
    ]] = scala
      .Option(impl.vpcSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.VpcSecurityGroupMembership.wrap(item)
        }.toList
      )
    override val dbParameterGroups: scala.Option[List[
      zio.aws.rds.model.DBParameterGroupStatus.ReadOnly
    ]] = scala
      .Option(impl.dbParameterGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.DBParameterGroupStatus.wrap(item)
        }.toList
      )
    override val availabilityZone: scala.Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val dbSubnetGroup
        : scala.Option[zio.aws.rds.model.DBSubnetGroup.ReadOnly] = scala
      .Option(impl.dbSubnetGroup())
      .map(value => zio.aws.rds.model.DBSubnetGroup.wrap(value))
    override val preferredMaintenanceWindow: scala.Option[String] = scala
      .Option(impl.preferredMaintenanceWindow())
      .map(value => value: String)
    override val pendingModifiedValues
        : scala.Option[zio.aws.rds.model.PendingModifiedValues.ReadOnly] = scala
      .Option(impl.pendingModifiedValues())
      .map(value => zio.aws.rds.model.PendingModifiedValues.wrap(value))
    override val latestRestorableTime: scala.Option[TStamp] = scala
      .Option(impl.latestRestorableTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val multiAZ: scala.Option[Boolean] =
      scala.Option(impl.multiAZ()).map(value => value: Boolean)
    override val engineVersion: scala.Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val autoMinorVersionUpgrade: scala.Option[Boolean] =
      scala.Option(impl.autoMinorVersionUpgrade()).map(value => value: Boolean)
    override val readReplicaSourceDBInstanceIdentifier: scala.Option[String] =
      scala
        .Option(impl.readReplicaSourceDBInstanceIdentifier())
        .map(value => value: String)
    override val readReplicaDBInstanceIdentifiers: scala.Option[List[String]] =
      scala
        .Option(impl.readReplicaDBInstanceIdentifiers())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val readReplicaDBClusterIdentifiers: scala.Option[List[String]] =
      scala
        .Option(impl.readReplicaDBClusterIdentifiers())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val replicaMode: scala.Option[zio.aws.rds.model.ReplicaMode] =
      scala
        .Option(impl.replicaMode())
        .map(value => zio.aws.rds.model.ReplicaMode.wrap(value))
    override val licenseModel: scala.Option[String] =
      scala.Option(impl.licenseModel()).map(value => value: String)
    override val iops: scala.Option[IntegerOptional] = scala
      .Option(impl.iops())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val optionGroupMemberships
        : scala.Option[List[zio.aws.rds.model.OptionGroupMembership.ReadOnly]] =
      scala
        .Option(impl.optionGroupMemberships())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.OptionGroupMembership.wrap(item)
          }.toList
        )
    override val characterSetName: scala.Option[String] =
      scala.Option(impl.characterSetName()).map(value => value: String)
    override val ncharCharacterSetName: scala.Option[String] =
      scala.Option(impl.ncharCharacterSetName()).map(value => value: String)
    override val secondaryAvailabilityZone: scala.Option[String] =
      scala.Option(impl.secondaryAvailabilityZone()).map(value => value: String)
    override val publiclyAccessible: scala.Option[Boolean] =
      scala.Option(impl.publiclyAccessible()).map(value => value: Boolean)
    override val statusInfos
        : scala.Option[List[zio.aws.rds.model.DBInstanceStatusInfo.ReadOnly]] =
      scala
        .Option(impl.statusInfos())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.DBInstanceStatusInfo.wrap(item)
          }.toList
        )
    override val storageType: scala.Option[String] =
      scala.Option(impl.storageType()).map(value => value: String)
    override val tdeCredentialArn: scala.Option[String] =
      scala.Option(impl.tdeCredentialArn()).map(value => value: String)
    override val dbInstancePort: scala.Option[Integer] = scala
      .Option(impl.dbInstancePort())
      .map(value => zio.aws.rds.model.primitives.Integer(value))
    override val dbClusterIdentifier: scala.Option[String] =
      scala.Option(impl.dbClusterIdentifier()).map(value => value: String)
    override val storageEncrypted: scala.Option[Boolean] =
      scala.Option(impl.storageEncrypted()).map(value => value: Boolean)
    override val kmsKeyId: scala.Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val dbiResourceId: scala.Option[String] =
      scala.Option(impl.dbiResourceId()).map(value => value: String)
    override val caCertificateIdentifier: scala.Option[String] =
      scala.Option(impl.caCertificateIdentifier()).map(value => value: String)
    override val domainMemberships
        : scala.Option[List[zio.aws.rds.model.DomainMembership.ReadOnly]] =
      scala
        .Option(impl.domainMemberships())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.DomainMembership.wrap(item)
          }.toList
        )
    override val copyTagsToSnapshot: scala.Option[Boolean] =
      scala.Option(impl.copyTagsToSnapshot()).map(value => value: Boolean)
    override val monitoringInterval: scala.Option[IntegerOptional] = scala
      .Option(impl.monitoringInterval())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val enhancedMonitoringResourceArn: scala.Option[String] = scala
      .Option(impl.enhancedMonitoringResourceArn())
      .map(value => value: String)
    override val monitoringRoleArn: scala.Option[String] =
      scala.Option(impl.monitoringRoleArn()).map(value => value: String)
    override val promotionTier: scala.Option[IntegerOptional] = scala
      .Option(impl.promotionTier())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val dbInstanceArn: scala.Option[String] =
      scala.Option(impl.dbInstanceArn()).map(value => value: String)
    override val timezone: scala.Option[String] =
      scala.Option(impl.timezone()).map(value => value: String)
    override val iamDatabaseAuthenticationEnabled: scala.Option[Boolean] = scala
      .Option(impl.iamDatabaseAuthenticationEnabled())
      .map(value => value: Boolean)
    override val performanceInsightsEnabled: scala.Option[BooleanOptional] =
      scala
        .Option(impl.performanceInsightsEnabled())
        .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val performanceInsightsKMSKeyId: scala.Option[String] = scala
      .Option(impl.performanceInsightsKMSKeyId())
      .map(value => value: String)
    override val performanceInsightsRetentionPeriod
        : scala.Option[IntegerOptional] = scala
      .Option(impl.performanceInsightsRetentionPeriod())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val enabledCloudwatchLogsExports: scala.Option[List[String]] =
      scala
        .Option(impl.enabledCloudwatchLogsExports())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val processorFeatures
        : scala.Option[List[zio.aws.rds.model.ProcessorFeature.ReadOnly]] =
      scala
        .Option(impl.processorFeatures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.ProcessorFeature.wrap(item)
          }.toList
        )
    override val deletionProtection: scala.Option[Boolean] =
      scala.Option(impl.deletionProtection()).map(value => value: Boolean)
    override val associatedRoles
        : scala.Option[List[zio.aws.rds.model.DBInstanceRole.ReadOnly]] = scala
      .Option(impl.associatedRoles())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.DBInstanceRole.wrap(item)
        }.toList
      )
    override val listenerEndpoint
        : scala.Option[zio.aws.rds.model.Endpoint.ReadOnly] = scala
      .Option(impl.listenerEndpoint())
      .map(value => zio.aws.rds.model.Endpoint.wrap(value))
    override val maxAllocatedStorage: scala.Option[IntegerOptional] = scala
      .Option(impl.maxAllocatedStorage())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val tagList: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tagList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
    override val dbInstanceAutomatedBackupsReplications: scala.Option[List[
      zio.aws.rds.model.DBInstanceAutomatedBackupsReplication.ReadOnly
    ]] = scala
      .Option(impl.dbInstanceAutomatedBackupsReplications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.DBInstanceAutomatedBackupsReplication.wrap(item)
        }.toList
      )
    override val customerOwnedIpEnabled: scala.Option[BooleanOptional] = scala
      .Option(impl.customerOwnedIpEnabled())
      .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val awsBackupRecoveryPointArn: scala.Option[String] =
      scala.Option(impl.awsBackupRecoveryPointArn()).map(value => value: String)
    override val activityStreamStatus
        : scala.Option[zio.aws.rds.model.ActivityStreamStatus] = scala
      .Option(impl.activityStreamStatus())
      .map(value => zio.aws.rds.model.ActivityStreamStatus.wrap(value))
    override val activityStreamKmsKeyId: scala.Option[String] =
      scala.Option(impl.activityStreamKmsKeyId()).map(value => value: String)
    override val activityStreamKinesisStreamName: scala.Option[String] = scala
      .Option(impl.activityStreamKinesisStreamName())
      .map(value => value: String)
    override val activityStreamMode
        : scala.Option[zio.aws.rds.model.ActivityStreamMode] = scala
      .Option(impl.activityStreamMode())
      .map(value => zio.aws.rds.model.ActivityStreamMode.wrap(value))
    override val activityStreamEngineNativeAuditFieldsIncluded
        : scala.Option[BooleanOptional] = scala
      .Option(impl.activityStreamEngineNativeAuditFieldsIncluded())
      .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val automationMode
        : scala.Option[zio.aws.rds.model.AutomationMode] = scala
      .Option(impl.automationMode())
      .map(value => zio.aws.rds.model.AutomationMode.wrap(value))
    override val resumeFullAutomationModeTime: scala.Option[TStamp] = scala
      .Option(impl.resumeFullAutomationModeTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val customIamInstanceProfile: scala.Option[String] =
      scala.Option(impl.customIamInstanceProfile()).map(value => value: String)
    override val backupTarget: scala.Option[String] =
      scala.Option(impl.backupTarget()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DBInstance
  ): zio.aws.rds.model.DBInstance.ReadOnly = new Wrapper(impl)
}
