package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DBClusterEndpoint(
    dbClusterEndpointIdentifier: scala.Option[String] = None,
    dbClusterIdentifier: scala.Option[String] = None,
    dbClusterEndpointResourceIdentifier: scala.Option[String] = None,
    endpoint: scala.Option[String] = None,
    status: scala.Option[String] = None,
    endpointType: scala.Option[String] = None,
    customEndpointType: scala.Option[String] = None,
    staticMembers: scala.Option[Iterable[String]] = None,
    excludedMembers: scala.Option[Iterable[String]] = None,
    dbClusterEndpointArn: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DBClusterEndpoint = {
    import DBClusterEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DBClusterEndpoint
      .builder()
      .optionallyWith(
        dbClusterEndpointIdentifier.map(value => value: java.lang.String)
      )(_.dbClusterEndpointIdentifier)
      .optionallyWith(
        dbClusterIdentifier.map(value => value: java.lang.String)
      )(_.dbClusterIdentifier)
      .optionallyWith(
        dbClusterEndpointResourceIdentifier.map(value =>
          value: java.lang.String
        )
      )(_.dbClusterEndpointResourceIdentifier)
      .optionallyWith(endpoint.map(value => value: java.lang.String))(
        _.endpoint
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(endpointType.map(value => value: java.lang.String))(
        _.endpointType
      )
      .optionallyWith(customEndpointType.map(value => value: java.lang.String))(
        _.customEndpointType
      )
      .optionallyWith(
        staticMembers.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.staticMembers)
      .optionallyWith(
        excludedMembers.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.excludedMembers)
      .optionallyWith(
        dbClusterEndpointArn.map(value => value: java.lang.String)
      )(_.dbClusterEndpointArn)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DBClusterEndpoint.ReadOnly =
    zio.aws.rds.model.DBClusterEndpoint.wrap(buildAwsValue())
}
object DBClusterEndpoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DBClusterEndpoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DBClusterEndpoint =
      zio.aws.rds.model.DBClusterEndpoint(
        dbClusterEndpointIdentifier.map(value => value),
        dbClusterIdentifier.map(value => value),
        dbClusterEndpointResourceIdentifier.map(value => value),
        endpoint.map(value => value),
        status.map(value => value),
        endpointType.map(value => value),
        customEndpointType.map(value => value),
        staticMembers.map(value => value),
        excludedMembers.map(value => value),
        dbClusterEndpointArn.map(value => value)
      )
    def dbClusterEndpointIdentifier: scala.Option[String]
    def dbClusterIdentifier: scala.Option[String]
    def dbClusterEndpointResourceIdentifier: scala.Option[String]
    def endpoint: scala.Option[String]
    def status: scala.Option[String]
    def endpointType: scala.Option[String]
    def customEndpointType: scala.Option[String]
    def staticMembers: scala.Option[List[String]]
    def excludedMembers: scala.Option[List[String]]
    def dbClusterEndpointArn: scala.Option[String]
    def getDbClusterEndpointIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbClusterEndpointIdentifier",
        dbClusterEndpointIdentifier
      )
    def getDbClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifier)
    def getDbClusterEndpointResourceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbClusterEndpointResourceIdentifier",
        dbClusterEndpointResourceIdentifier
      )
    def getEndpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getEndpointType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpointType", endpointType)
    def getCustomEndpointType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("customEndpointType", customEndpointType)
    def getStaticMembers: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("staticMembers", staticMembers)
    def getExcludedMembers: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("excludedMembers", excludedMembers)
    def getDbClusterEndpointArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterEndpointArn", dbClusterEndpointArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DBClusterEndpoint
  ) extends zio.aws.rds.model.DBClusterEndpoint.ReadOnly {
    override val dbClusterEndpointIdentifier: scala.Option[String] = scala
      .Option(impl.dbClusterEndpointIdentifier())
      .map(value => value: String)
    override val dbClusterIdentifier: scala.Option[String] =
      scala.Option(impl.dbClusterIdentifier()).map(value => value: String)
    override val dbClusterEndpointResourceIdentifier: scala.Option[String] =
      scala
        .Option(impl.dbClusterEndpointResourceIdentifier())
        .map(value => value: String)
    override val endpoint: scala.Option[String] =
      scala.Option(impl.endpoint()).map(value => value: String)
    override val status: scala.Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val endpointType: scala.Option[String] =
      scala.Option(impl.endpointType()).map(value => value: String)
    override val customEndpointType: scala.Option[String] =
      scala.Option(impl.customEndpointType()).map(value => value: String)
    override val staticMembers: scala.Option[List[String]] = scala
      .Option(impl.staticMembers())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val excludedMembers: scala.Option[List[String]] = scala
      .Option(impl.excludedMembers())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val dbClusterEndpointArn: scala.Option[String] =
      scala.Option(impl.dbClusterEndpointArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DBClusterEndpoint
  ): zio.aws.rds.model.DBClusterEndpoint.ReadOnly = new Wrapper(impl)
}
