package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateDbSecurityGroupRequest(
    dbSecurityGroupName: String,
    dbSecurityGroupDescription: String,
    tags: scala.Option[Iterable[zio.aws.rds.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CreateDbSecurityGroupRequest = {
    import CreateDbSecurityGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CreateDbSecurityGroupRequest
      .builder()
      .dbSecurityGroupName(dbSecurityGroupName: java.lang.String)
      .dbSecurityGroupDescription(dbSecurityGroupDescription: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.CreateDbSecurityGroupRequest.ReadOnly =
    zio.aws.rds.model.CreateDbSecurityGroupRequest.wrap(buildAwsValue())
}
object CreateDbSecurityGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CreateDbSecurityGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CreateDbSecurityGroupRequest =
      zio.aws.rds.model.CreateDbSecurityGroupRequest(
        dbSecurityGroupName,
        dbSecurityGroupDescription,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dbSecurityGroupName: String
    def dbSecurityGroupDescription: String
    def tags: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]]
    def getDbSecurityGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbSecurityGroupName)
    def getDbSecurityGroupDescription: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbSecurityGroupDescription)
    def getTags: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CreateDbSecurityGroupRequest
  ) extends zio.aws.rds.model.CreateDbSecurityGroupRequest.ReadOnly {
    override val dbSecurityGroupName: String =
      impl.dbSecurityGroupName(): String
    override val dbSecurityGroupDescription: String =
      impl.dbSecurityGroupDescription(): String
    override val tags: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CreateDbSecurityGroupRequest
  ): zio.aws.rds.model.CreateDbSecurityGroupRequest.ReadOnly = new Wrapper(impl)
}
