package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateDbParameterGroupResponse(
    dbParameterGroup: scala.Option[zio.aws.rds.model.DBParameterGroup] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CreateDbParameterGroupResponse = {
    import CreateDbParameterGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CreateDbParameterGroupResponse
      .builder()
      .optionallyWith(dbParameterGroup.map(value => value.buildAwsValue()))(
        _.dbParameterGroup
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.CreateDbParameterGroupResponse.ReadOnly =
    zio.aws.rds.model.CreateDbParameterGroupResponse.wrap(buildAwsValue())
}
object CreateDbParameterGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CreateDbParameterGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CreateDbParameterGroupResponse =
      zio.aws.rds.model.CreateDbParameterGroupResponse(
        dbParameterGroup.map(value => value.asEditable)
      )
    def dbParameterGroup
        : scala.Option[zio.aws.rds.model.DBParameterGroup.ReadOnly]
    def getDbParameterGroup
        : ZIO[Any, AwsError, zio.aws.rds.model.DBParameterGroup.ReadOnly] =
      AwsError.unwrapOptionField("dbParameterGroup", dbParameterGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CreateDbParameterGroupResponse
  ) extends zio.aws.rds.model.CreateDbParameterGroupResponse.ReadOnly {
    override val dbParameterGroup
        : scala.Option[zio.aws.rds.model.DBParameterGroup.ReadOnly] = scala
      .Option(impl.dbParameterGroup())
      .map(value => zio.aws.rds.model.DBParameterGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CreateDbParameterGroupResponse
  ): zio.aws.rds.model.CreateDbParameterGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
