package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AvailableProcessorFeature(
    name: scala.Option[String] = None,
    defaultValue: scala.Option[String] = None,
    allowedValues: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.AvailableProcessorFeature = {
    import AvailableProcessorFeature.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.AvailableProcessorFeature
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(defaultValue.map(value => value: java.lang.String))(
        _.defaultValue
      )
      .optionallyWith(allowedValues.map(value => value: java.lang.String))(
        _.allowedValues
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.AvailableProcessorFeature.ReadOnly =
    zio.aws.rds.model.AvailableProcessorFeature.wrap(buildAwsValue())
}
object AvailableProcessorFeature {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.AvailableProcessorFeature
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.AvailableProcessorFeature =
      zio.aws.rds.model.AvailableProcessorFeature(
        name.map(value => value),
        defaultValue.map(value => value),
        allowedValues.map(value => value)
      )
    def name: scala.Option[String]
    def defaultValue: scala.Option[String]
    def allowedValues: scala.Option[String]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getDefaultValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("defaultValue", defaultValue)
    def getAllowedValues: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("allowedValues", allowedValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.AvailableProcessorFeature
  ) extends zio.aws.rds.model.AvailableProcessorFeature.ReadOnly {
    override val name: scala.Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val defaultValue: scala.Option[String] =
      scala.Option(impl.defaultValue()).map(value => value: String)
    override val allowedValues: scala.Option[String] =
      scala.Option(impl.allowedValues()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.AvailableProcessorFeature
  ): zio.aws.rds.model.AvailableProcessorFeature.ReadOnly = new Wrapper(impl)
}
