package zio.aws.rds.model
import zio.aws.rds.model.primitives.StringSensitive
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class VpnDetails(
    vpnId: scala.Option[String] = None,
    vpnTunnelOriginatorIP: scala.Option[String] = None,
    vpnGatewayIp: scala.Option[String] = None,
    vpnPSK: scala.Option[StringSensitive] = None,
    vpnName: scala.Option[String] = None,
    vpnState: scala.Option[String] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.rds.model.VpnDetails = {
    import VpnDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.VpnDetails
      .builder()
      .optionallyWith(vpnId.map(value => value: java.lang.String))(_.vpnId)
      .optionallyWith(
        vpnTunnelOriginatorIP.map(value => value: java.lang.String)
      )(_.vpnTunnelOriginatorIP)
      .optionallyWith(vpnGatewayIp.map(value => value: java.lang.String))(
        _.vpnGatewayIp
      )
      .optionallyWith(
        vpnPSK.map(value => StringSensitive.unwrap(value): java.lang.String)
      )(_.vpnPSK)
      .optionallyWith(vpnName.map(value => value: java.lang.String))(_.vpnName)
      .optionallyWith(vpnState.map(value => value: java.lang.String))(
        _.vpnState
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.VpnDetails.ReadOnly =
    zio.aws.rds.model.VpnDetails.wrap(buildAwsValue())
}
object VpnDetails {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.VpnDetails] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.VpnDetails = zio.aws.rds.model.VpnDetails(
      vpnId.map(value => value),
      vpnTunnelOriginatorIP.map(value => value),
      vpnGatewayIp.map(value => value),
      vpnPSK.map(value => value),
      vpnName.map(value => value),
      vpnState.map(value => value)
    )
    def vpnId: scala.Option[String]
    def vpnTunnelOriginatorIP: scala.Option[String]
    def vpnGatewayIp: scala.Option[String]
    def vpnPSK: scala.Option[StringSensitive]
    def vpnName: scala.Option[String]
    def vpnState: scala.Option[String]
    def getVpnId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpnId", vpnId)
    def getVpnTunnelOriginatorIP: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpnTunnelOriginatorIP", vpnTunnelOriginatorIP)
    def getVpnGatewayIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpnGatewayIp", vpnGatewayIp)
    def getVpnPSK: ZIO[Any, AwsError, StringSensitive] =
      AwsError.unwrapOptionField("vpnPSK", vpnPSK)
    def getVpnName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpnName", vpnName)
    def getVpnState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpnState", vpnState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.VpnDetails
  ) extends zio.aws.rds.model.VpnDetails.ReadOnly {
    override val vpnId: scala.Option[String] =
      scala.Option(impl.vpnId()).map(value => value: String)
    override val vpnTunnelOriginatorIP: scala.Option[String] =
      scala.Option(impl.vpnTunnelOriginatorIP()).map(value => value: String)
    override val vpnGatewayIp: scala.Option[String] =
      scala.Option(impl.vpnGatewayIp()).map(value => value: String)
    override val vpnPSK: scala.Option[StringSensitive] = scala
      .Option(impl.vpnPSK())
      .map(value => zio.aws.rds.model.primitives.StringSensitive(value))
    override val vpnName: scala.Option[String] =
      scala.Option(impl.vpnName()).map(value => value: String)
    override val vpnState: scala.Option[String] =
      scala.Option(impl.vpnState()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.VpnDetails
  ): zio.aws.rds.model.VpnDetails.ReadOnly = new Wrapper(impl)
}
