package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class StartDbClusterRequest(dbClusterIdentifier: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.StartDbClusterRequest = {
    import StartDbClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.StartDbClusterRequest
      .builder()
      .dbClusterIdentifier(dbClusterIdentifier: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.StartDbClusterRequest.ReadOnly =
    zio.aws.rds.model.StartDbClusterRequest.wrap(buildAwsValue())
}
object StartDbClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.StartDbClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.StartDbClusterRequest =
      zio.aws.rds.model.StartDbClusterRequest(dbClusterIdentifier)
    def dbClusterIdentifier: String
    def getDbClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.StartDbClusterRequest
  ) extends zio.aws.rds.model.StartDbClusterRequest.ReadOnly {
    override val dbClusterIdentifier: String =
      impl.dbClusterIdentifier(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.StartDbClusterRequest
  ): zio.aws.rds.model.StartDbClusterRequest.ReadOnly = new Wrapper(impl)
}
