package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ResetDbClusterParameterGroupRequest(
    dbClusterParameterGroupName: String,
    resetAllParameters: scala.Option[Boolean] = None,
    parameters: scala.Option[Iterable[zio.aws.rds.model.Parameter]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ResetDbClusterParameterGroupRequest = {
    import ResetDbClusterParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ResetDbClusterParameterGroupRequest
      .builder()
      .dbClusterParameterGroupName(
        dbClusterParameterGroupName: java.lang.String
      )
      .optionallyWith(
        resetAllParameters.map(value => value: java.lang.Boolean)
      )(_.resetAllParameters)
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.ResetDbClusterParameterGroupRequest.ReadOnly =
    zio.aws.rds.model.ResetDbClusterParameterGroupRequest.wrap(buildAwsValue())
}
object ResetDbClusterParameterGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ResetDbClusterParameterGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ResetDbClusterParameterGroupRequest =
      zio.aws.rds.model.ResetDbClusterParameterGroupRequest(
        dbClusterParameterGroupName,
        resetAllParameters.map(value => value),
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dbClusterParameterGroupName: String
    def resetAllParameters: scala.Option[Boolean]
    def parameters: scala.Option[List[zio.aws.rds.model.Parameter.ReadOnly]]
    def getDbClusterParameterGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterParameterGroupName)
    def getResetAllParameters: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("resetAllParameters", resetAllParameters)
    def getParameters
        : ZIO[Any, AwsError, List[zio.aws.rds.model.Parameter.ReadOnly]] =
      AwsError.unwrapOptionField("parameters", parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ResetDbClusterParameterGroupRequest
  ) extends zio.aws.rds.model.ResetDbClusterParameterGroupRequest.ReadOnly {
    override val dbClusterParameterGroupName: String =
      impl.dbClusterParameterGroupName(): String
    override val resetAllParameters: scala.Option[Boolean] =
      scala.Option(impl.resetAllParameters()).map(value => value: Boolean)
    override val parameters
        : scala.Option[List[zio.aws.rds.model.Parameter.ReadOnly]] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.Parameter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ResetDbClusterParameterGroupRequest
  ): zio.aws.rds.model.ResetDbClusterParameterGroupRequest.ReadOnly =
    new Wrapper(impl)
}
