package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ModifyDbSubnetGroupRequest(
    dbSubnetGroupName: String,
    dbSubnetGroupDescription: scala.Option[String] = None,
    subnetIds: Iterable[String]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ModifyDbSubnetGroupRequest = {
    import ModifyDbSubnetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ModifyDbSubnetGroupRequest
      .builder()
      .dbSubnetGroupName(dbSubnetGroupName: java.lang.String)
      .optionallyWith(
        dbSubnetGroupDescription.map(value => value: java.lang.String)
      )(_.dbSubnetGroupDescription)
      .subnetIds(subnetIds.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ModifyDbSubnetGroupRequest.ReadOnly =
    zio.aws.rds.model.ModifyDbSubnetGroupRequest.wrap(buildAwsValue())
}
object ModifyDbSubnetGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ModifyDbSubnetGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ModifyDbSubnetGroupRequest =
      zio.aws.rds.model.ModifyDbSubnetGroupRequest(
        dbSubnetGroupName,
        dbSubnetGroupDescription.map(value => value),
        subnetIds
      )
    def dbSubnetGroupName: String
    def dbSubnetGroupDescription: scala.Option[String]
    def subnetIds: List[String]
    def getDbSubnetGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbSubnetGroupName)
    def getDbSubnetGroupDescription: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("dbSubnetGroupDescription", dbSubnetGroupDescription)
    def getSubnetIds: ZIO[Any, Nothing, List[String]] = ZIO.succeed(subnetIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ModifyDbSubnetGroupRequest
  ) extends zio.aws.rds.model.ModifyDbSubnetGroupRequest.ReadOnly {
    override val dbSubnetGroupName: String = impl.dbSubnetGroupName(): String
    override val dbSubnetGroupDescription: scala.Option[String] =
      scala.Option(impl.dbSubnetGroupDescription()).map(value => value: String)
    override val subnetIds: List[String] = impl
      .subnetIds()
      .asScala
      .map { item =>
        item: String
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ModifyDbSubnetGroupRequest
  ): zio.aws.rds.model.ModifyDbSubnetGroupRequest.ReadOnly = new Wrapper(impl)
}
